/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.StringUtils;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.storage.IDirectory;

public class ExperimentIdentifier
implements IStorable {
    static final String FOLDER = "experiment_identifier";
    static final String INSTANCE_CODE = "instance_code";
    static final String GROUP_CODE = "group_code";
    static final String PROJECT_CODE = "project_code";
    static final String EXPERIMENT_CODE = "experiment_code";
    private final String instanceCode;
    private final String groupCode;
    private final String projectCode;
    private final String experimentCode;

    static final ExperimentIdentifier loadFrom(IDirectory directory) {
        IDirectory idFolder = Utilities.getSubDirectory(directory, FOLDER);
        String instanceCode = Utilities.getTrimmedString(idFolder, INSTANCE_CODE);
        String groupCode = Utilities.getTrimmedString(idFolder, GROUP_CODE);
        String projectCode = Utilities.getTrimmedString(idFolder, PROJECT_CODE);
        String experimentCode = Utilities.getTrimmedString(idFolder, EXPERIMENT_CODE);
        return new ExperimentIdentifier(instanceCode, groupCode, projectCode, experimentCode);
    }

    public ExperimentIdentifier(String instanceCode, String groupCode, String projectCode, String experimentCode) {
        assert (!StringUtils.isEmpty(instanceCode)) : "Undefined instance code";
        this.instanceCode = instanceCode;
        assert (!StringUtils.isEmpty(groupCode)) : "Undefined group code";
        this.groupCode = groupCode;
        assert (!StringUtils.isEmpty(projectCode)) : "Undefined project code";
        this.projectCode = projectCode;
        assert (!StringUtils.isEmpty(experimentCode)) : "Undefined experiment code";
        this.experimentCode = experimentCode;
    }

    public final String getInstanceCode() {
        return this.instanceCode;
    }

    public final String getGroupCode() {
        return this.groupCode;
    }

    public final String getProjectCode() {
        return this.projectCode;
    }

    public final String getExperimentCode() {
        return this.experimentCode;
    }

    public final void saveTo(IDirectory directory) {
        IDirectory folder = directory.makeDirectory(FOLDER);
        folder.addKeyValuePair(INSTANCE_CODE, this.instanceCode);
        folder.addKeyValuePair(GROUP_CODE, this.groupCode);
        folder.addKeyValuePair(PROJECT_CODE, this.projectCode);
        folder.addKeyValuePair(EXPERIMENT_CODE, this.experimentCode);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExperimentIdentifier)) {
            return false;
        }
        ExperimentIdentifier id = (ExperimentIdentifier)obj;
        return id.instanceCode.equals(this.instanceCode) && id.groupCode.equals(this.groupCode) && id.projectCode.equals(this.projectCode) && id.experimentCode.equals(this.experimentCode);
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + this.instanceCode.hashCode();
        result = 37 * result + this.groupCode.hashCode();
        result = 37 * result + this.projectCode.hashCode();
        result = 37 * result + this.experimentCode.hashCode();
        return result;
    }

    public final String toString() {
        return "[instance:" + this.instanceCode + ",group:" + this.groupCode + ",project:" + this.projectCode + ",experiment:" + this.experimentCode + "]";
    }
}

