/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.storage.IDirectory;

public final class ExperimentRegistrator
implements IStorable {
    static final String FOLDER = "experiment_registrator";
    static final String FIRST_NAME = "first_name";
    static final String SECOND_NAME = "last_name";
    static final String EMAIL = "email";
    private final String firstName;
    private final String secondName;
    private final String email;

    static ExperimentRegistrator loadFrom(IDirectory directory) {
        IDirectory folder = Utilities.getSubDirectory(directory, FOLDER);
        String firstName = Utilities.getTrimmedString(folder, FIRST_NAME);
        String secondName = Utilities.getTrimmedString(folder, SECOND_NAME);
        String email = Utilities.getTrimmedString(folder, EMAIL);
        return new ExperimentRegistrator(firstName, secondName, email);
    }

    public ExperimentRegistrator(String firstName, String secondName, String email) {
        assert (firstName != null && firstName.length() > 0) : "Undefined first name";
        this.firstName = firstName;
        assert (secondName != null && secondName.length() > 0) : "Undefined second name";
        this.secondName = secondName;
        assert (email != null && email.length() > 0) : "Undefined email";
        this.email = email;
    }

    public final String getFirstName() {
        return this.firstName;
    }

    public final String getSecondName() {
        return this.secondName;
    }

    public final String getEmail() {
        return this.email;
    }

    public final void saveTo(IDirectory directory) {
        IDirectory folder = directory.makeDirectory(FOLDER);
        folder.addKeyValuePair(FIRST_NAME, this.firstName);
        folder.addKeyValuePair(SECOND_NAME, this.secondName);
        folder.addKeyValuePair(EMAIL, this.email);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExperimentRegistrator)) {
            return false;
        }
        ExperimentRegistrator registrator = (ExperimentRegistrator)obj;
        return registrator.firstName.equals(this.firstName) && registrator.secondName.equals(this.secondName) && registrator.email.equals(this.email);
    }

    public int hashCode() {
        return (this.firstName.hashCode() * 37 + this.secondName.hashCode()) * 37 + this.email.hashCode();
    }

    public String toString() {
        return String.valueOf(this.firstName) + " " + this.secondName + ", e-mail:" + this.email;
    }
}

