/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.exception.StorageException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.ILink;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.filesystem.AbstractNode;
import ch.systemsx.cisd.bds.storage.filesystem.File;
import ch.systemsx.cisd.bds.storage.filesystem.Link;
import ch.systemsx.cisd.bds.storage.filesystem.LinkMakerProvider;
import ch.systemsx.cisd.bds.storage.filesystem.NodeFactory;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Directory
extends AbstractNode
implements IDirectory {
    Directory(java.io.File directory) {
        super(directory);
        if (!directory.isDirectory()) {
            throw new StorageException(String.format("Not a directory '%s'.", directory.getAbsolutePath()));
        }
    }

    private static final java.io.File getNodeFile(INode node) {
        assert (node instanceof AbstractNode) : "Must be an instance of AbstractNode.";
        return ((AbstractNode)node).nodeFile;
    }

    private static final String cleanName(String name) {
        int index = name.indexOf(47);
        if (index == 0) {
            return name.substring(1);
        }
        return name;
    }

    @Override
    public final INode tryGetNode(String name) {
        assert (name != null) : "Given name can not be null.";
        String path = Directory.cleanName(name.replace('\\', '/'));
        java.io.File childrenNodeFile = new java.io.File(this.nodeFile, path);
        if (childrenNodeFile.exists()) {
            return NodeFactory.createNode(childrenNodeFile);
        }
        return null;
    }

    @Override
    public final IDirectory makeDirectory(String name) {
        assert (name != null) : "Given name can not be null.";
        java.io.File dir = new java.io.File(this.nodeFile, name);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new StorageException("There already exists a file named '" + name + "' in directory " + this);
            }
            return new Directory(dir);
        }
        boolean successful = dir.mkdir();
        if (!successful) {
            throw new EnvironmentFailureException("Couldn't create directory " + dir.getAbsolutePath() + " for some unknown reason.");
        }
        return new Directory(dir);
    }

    @Override
    public final IFile addKeyValuePair(String key, String value) {
        assert (key != null) : "Given key can not be null.";
        if (value == null) {
            throw new IllegalArgumentException("Value for key '" + key + "' not specified.");
        }
        java.io.File file = new java.io.File(this.nodeFile, key);
        FileUtilities.writeToFile(file, value);
        return new File(file);
    }

    @Override
    public final INode addFile(java.io.File file, String name, boolean move) {
        Directory.checkFile(file);
        String fileName = name == null ? file.getName() : name;
        java.io.File newFile = new java.io.File(this.nodeFile, fileName);
        if (move) {
            Directory.moveFileToDirectory(file, this.nodeFile, name);
        } else {
            try {
                if (file.isDirectory()) {
                    FileUtils.copyDirectory((java.io.File)file, (java.io.File)newFile);
                } else {
                    FileUtils.copyFile((java.io.File)file, (java.io.File)newFile);
                }
            }
            catch (IOException ex) {
                throw EnvironmentFailureException.fromTemplate(ex, "Couldn't not copy file '%s' to directory '%s'.", file, this.nodeFile.getAbsolutePath());
            }
        }
        return NodeFactory.createNode(newFile);
    }

    @Override
    public final ILink tryAddLink(String name, INode node) {
        assert (node != null) : "Node can not be null.";
        assert (name != null) : "Name can not be null.";
        java.io.File file = Directory.getNodeFile(node);
        java.io.File fileLink = LinkMakerProvider.getLinkMaker().tryCopy(file, this.nodeFile, name);
        if (fileLink != null) {
            Link link = (Link)NodeFactory.createLinkNode(name, file);
            link.setParent(this);
            return link;
        }
        return null;
    }

    @Override
    public final Iterator<INode> iterator() {
        return new Iterator<INode>(){
            private java.io.File[] files;
            private int index;
            {
                this.files = FileUtilities.listFiles(Directory.this.nodeFile);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public INode next() {
                return this.index >= this.files.length ? null : NodeFactory.createNode(this.files[this.index++]);
            }

            @Override
            public boolean hasNext() {
                return this.index < this.files.length;
            }
        };
    }

    @Override
    public final void extractTo(java.io.File directory) throws EnvironmentFailureException {
        assert (directory != null) : "Directory could not be null";
        try {
            FileUtils.copyDirectoryToDirectory((java.io.File)this.nodeFile, (java.io.File)directory);
        }
        catch (IOException ex) {
            throw EnvironmentFailureException.fromTemplate(ex, "Couldn't copy directory '%s' to directory '%s'.", this.nodeFile.getAbsolutePath(), directory.getAbsolutePath());
        }
    }

    @Override
    public final void removeNode(INode node) {
        assert (node != null) : "Node could not be null";
        java.io.File file = Directory.getNodeFile(node);
        if (file.isDirectory()) {
            if (!FileUtilities.deleteRecursively(file, null)) {
                throw EnvironmentFailureException.fromTemplate("Couldn't remove directory '%s'.", file.getAbsolutePath());
            }
        } else if (file.isFile() && !file.delete()) {
            throw EnvironmentFailureException.fromTemplate("Couldn't remove file '%s'.", file.getAbsolutePath());
        }
    }

    @Override
    public final boolean isValid() {
        return super.isValid() && FileUtilities.checkDirectoryFullyAccessible(this.nodeFile, "") == null;
    }
}

