/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.utilities.IPathImmutableCopier;
import ch.systemsx.cisd.common.utilities.RecursiveHardLinkMaker;

public final class LinkMakerProvider {
    private static final String NO_HARD_LINK_EXECUTABLE = "No hard link executable has been found.";
    private static final long MILLIS_TO_WAIT_FOR_COMPLETION = 10000L;
    private static final long MILLIS_TO_SLEEP_AFTER_COPY_FAILS = 3000L;
    private static final int MAX_COPY_RETRIES = 7;
    private static IPathImmutableCopier hardLinkMaker;

    private LinkMakerProvider() {
    }

    private static final IPathImmutableCopier tryCreateHardLinkMaker() {
        IPathImmutableCopier copier = RecursiveHardLinkMaker.tryCreateRetrying(10000L, 7, 3000L);
        if (copier != null) {
            return copier;
        }
        throw new EnvironmentFailureException(NO_HARD_LINK_EXECUTABLE);
    }

    public static final IPathImmutableCopier getLinkMaker() {
        if (hardLinkMaker == null) {
            hardLinkMaker = LinkMakerProvider.tryCreateHardLinkMaker();
        }
        return hardLinkMaker;
    }
}

