/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.exceptions;

import java.io.Serializable;

public final class NotImplementedException
extends RuntimeException {
    static final String MESSAGE_TEMPLATE = "'%s' method not implemented in '%s'.";
    private static final long serialVersionUID = 1L;
    private final String message;

    public NotImplementedException() {
        StackTraceExtractor extractor = new StackTraceExtractor(this);
        this.message = String.format(MESSAGE_TEMPLATE, extractor.getMethodName(), extractor.getSimpleClassName());
    }

    public NotImplementedException(String message) {
        super(message);
        this.message = null;
    }

    public NotImplementedException(Throwable cause) {
        super(cause);
        this.message = null;
    }

    public NotImplementedException(String message, Throwable cause) {
        super(message, cause);
        this.message = null;
    }

    public final String getMessage() {
        if (this.message == null) {
            return super.getMessage();
        }
        return this.message;
    }

    public static class StackTraceExtractor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Throwable throwable;
        private final int index;

        public StackTraceExtractor(Throwable throwable) {
            this(throwable, 0);
        }

        public StackTraceExtractor(Throwable throwable, int index) {
            this.throwable = throwable;
            this.index = index;
        }

        public final String getClassName() {
            return this.throwable.getStackTrace()[this.index].getClassName();
        }

        public final String getMethodName() {
            return this.throwable.getStackTrace()[this.index].getMethodName();
        }

        public final String getSimpleClassName() {
            String fullClassName = this.getClassName();
            if (fullClassName == null || "".equals(fullClassName)) {
                return "";
            }
            int lastDot = fullClassName.lastIndexOf(46);
            if (lastDot < 0) {
                return fullClassName;
            }
            return fullClassName.substring(++lastDot);
        }
    }
}

