/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public final class ExtendedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_SEPARATOR = ", ";
    private static final String SUFFIX = "}";
    private static final String PREFIX = "${";
    private static final int MIN_LENGTH = "${".length() + "}".length() + 1;

    public static ExtendedProperties createWith(Properties properties) {
        assert (properties != null) : "Unspecified properties.";
        ExtendedProperties result = new ExtendedProperties();
        result.putAll((Map<?, ?>)properties);
        return result;
    }

    public static ExtendedProperties getSubset(Properties properties, String prefix, boolean dropPrefix) {
        return ExtendedProperties.createWith(properties).getSubset(prefix, dropPrefix);
    }

    public final ExtendedProperties getSubset(String prefix, boolean dropPrefix) {
        assert (prefix != null) : "Missing prefix";
        ExtendedProperties result = new ExtendedProperties();
        int prefixLength = prefix.length();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            if (!key.startsWith(prefix)) continue;
            result.put(dropPrefix ? key.substring(prefixLength) : key, this.getProperty(key));
        }
        return result;
    }

    public void removeSubset(String prefix) {
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            if (!key.startsWith(prefix)) continue;
            this.remove(key);
        }
    }

    private final String expandValue(String key, String value) {
        if (value == null || value.length() < MIN_LENGTH) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.length());
        result.append(value);
        int startName = result.indexOf(PREFIX);
        int prefixLen = PREFIX.length();
        int endName = result.indexOf(SUFFIX, startName + prefixLen);
        int suffixLen = SUFFIX.length();
        while (startName >= 0 && endName > startName) {
            String paramName = result.substring(startName + prefixLen, endName);
            this.remove(key);
            String paramValue = this.getProperty(paramName);
            super.setProperty(key, value);
            if (paramValue != null) {
                result.replace(startName, endName + suffixLen, paramValue);
                startName += paramValue.length();
            } else {
                startName = endName + suffixLen;
            }
            startName = result.indexOf(PREFIX, startName);
            endName = result.indexOf(SUFFIX, startName + prefixLen);
        }
        return result.toString();
    }

    public final String getUnalteredProperty(String key) {
        return (String)this.get(key);
    }

    public final String getProperty(String key) {
        String result = super.getProperty(key);
        return result == null ? null : this.expandValue(key, result);
    }

    public final String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        return result == null ? this.expandValue(key, defaultValue) : result;
    }

    public final String toString() {
        return StringUtils.replace((String)super.toString(), (String)PROPERTY_SEPARATOR, (String)SystemUtils.LINE_SEPARATOR);
    }
}

