/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.FileRenamingProcess;
import ch.systemsx.cisd.common.process.ProcessRunner;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

final class DataSetMover {
    private static final String MILLIS_TO_SLEEP_KEY = "renaming.failure.millis-to-sleep";
    private static final String MAX_RETRIES_KEY = "renaming.failure.max-retries";
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataSetMover.class);
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetMover.class);
    private static final ISimpleLogger simpleLogger = new Log4jSimpleLogger(operationLog, Level.WARN);
    private final int maxRetries;
    private final long millisToSleep;

    DataSetMover(Properties propertiesOrNull) {
        Properties properties = propertiesOrNull == null ? new Properties() : propertiesOrNull;
        this.maxRetries = PropertyUtils.getInt(properties, MAX_RETRIES_KEY, 12, simpleLogger);
        this.millisToSleep = PropertyUtils.getLong(properties, MILLIS_TO_SLEEP_KEY, 5000L, simpleLogger);
    }

    final boolean moveDataSetAndLog(File incomingDataSetFile, File targetFile) {
        String absoluteTargetPath = targetFile.getAbsolutePath();
        if (targetFile.exists()) {
            notificationLog.error(String.format("Target path '%s' of incoming data set already exists. Won't overwrite it.", absoluteTargetPath));
            return false;
        }
        FileRenamingProcess process = new FileRenamingProcess(this.maxRetries, this.millisToSleep, incomingDataSetFile, targetFile);
        new ProcessRunner(process);
        boolean movedOK = process.isRenamed();
        if (movedOK) {
            if (operationLog.isInfoEnabled()) {
                String entity = incomingDataSetFile.isDirectory() ? "directory" : "file";
                String name = incomingDataSetFile.getName();
                String parent = incomingDataSetFile.getParent();
                String path = targetFile.getParent();
                operationLog.info(String.format("Moving %s '%s' from '%s' to '%s'.", entity, name, parent, path));
            }
        } else {
            notificationLog.error(String.format("Moving '%s' to '%s' failed, giving up.", incomingDataSetFile.getAbsolutePath(), absoluteTargetPath));
        }
        return movedOK;
    }
}

