/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.utilities.IPathImmutableCopier;
import ch.systemsx.cisd.etlserver.IFile;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileBasedFile
implements IFile {
    private final IPathImmutableCopier hardLinkCopierOrNull;
    private final File file;

    public FileBasedFile(File file, IPathImmutableCopier hardLinkCopierOrNull) {
        assert (file != null) : "Unspecified file.";
        this.file = file;
        this.hardLinkCopierOrNull = hardLinkCopierOrNull;
    }

    public void copyFrom(File sourceFile) {
        this.copy(sourceFile, this.file);
    }

    public void copyTo(File destinationFile) {
        this.copy(this.file, destinationFile);
    }

    private void copy(File sourceFile, File destinationFile) {
        if (this.hardLinkCopierOrNull != null) {
            File destinationDirectory = destinationFile.getParentFile();
            File result = this.hardLinkCopierOrNull.tryCopy(sourceFile, destinationDirectory, destinationFile.getName());
            if (result == null) {
                throw new EnvironmentFailureException("Couldn't copy '" + sourceFile.getAbsolutePath() + "' using hard links to '" + destinationFile.getAbsolutePath() + "'. Maybe the destination already exists?");
            }
        } else {
            try {
                StopException.check();
                if (sourceFile.isDirectory()) {
                    FileUtils.copyDirectory((File)sourceFile, (File)destinationFile, (boolean)true);
                } else {
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile, (boolean)true);
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    public void delete() {
        if (this.file.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)this.file);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        } else if (!this.file.delete()) {
            throw new EnvironmentFailureException("Couldn't delete file '" + this.file.getAbsolutePath() + "' for some unknown reason");
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean canReadAndWrite() {
        return this.file.canRead() && this.file.canWrite();
    }

    public byte[] read() {
        try {
            return FileUtils.readFileToByteArray((File)this.file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public void write(byte[] data) {
        try {
            FileUtils.writeByteArrayToFile((File)this.file, (byte[])data);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }
}

