/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.common.utilities.ExtendedProperties;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    private static final String SERVICE_PROPERTIES_FILE = "etc/service.properties";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, Parameters.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, Parameters.class);
    private static final String INPUT_THREAD_NAMES = "inputs";
    private static final String ITEMS_DELIMITER = ",";
    @Option(name="s", longName="server-url", metaVar="URL", usage="URL of the server")
    private String serverURL;
    @Option(name="c", longName="check-interval", usage="The interval to wait between two checks (in seconds) [default: 120]")
    private long checkIntervalSeconds;
    @Option(name="t", longName="shutdown-timeout", usage="The time-out for clean up work in the shutdown sequence (in seconds) [default: 30]")
    private long shutdownTimeOutSeconds;
    @Option(name="m", longName="highwater-mark", usage="The minimal amount of diskspace that needs to be available in order to start processing a data set (in kilobytes) [default: 0]")
    private long highwaterMarkKb;
    @Option(name="u", longName="username", usage="User login name")
    private String username;
    @Option(name="p", longName="password", usage="User login password")
    private String password;
    @Option(longName="notify-successful-registration", usage="If true, a notification is sent on successful registration of a data set in openBIS [default: false]")
    private boolean sendNotificationOnSuccessFullRegistration;
    private Properties mailProperties;
    private final CmdLineParser parser = new CmdLineParser(this);
    private Properties serviceProperties;
    private ThreadParameters[] threads;
    private Map<String, Properties> processorProperties;

    @Option(longName="help", skipForExample=true, usage="Prints out a description of the options.")
    void printHelp(boolean exit) {
        this.parser.printHelp("etlserver", "<required options> [option [...]]", "", ExampleMode.ALL);
        if (exit) {
            System.exit(0);
        }
    }

    @Option(longName="version", skipForExample=true, usage="Prints out the version information.")
    void printVersion(boolean exit) {
        System.err.println("etlserver version " + BuildAndEnvironmentInfo.INSTANCE.getFullVersion());
        if (exit) {
            System.exit(0);
        }
    }

    @Option(longName="test-notify", skipForExample=true, usage="Tests the notify log (i.e. that an email is sent out).")
    void sendTestNotification(boolean exit) {
        notificationLog.error("This is a test notification given due to specifying the --test-notify option.");
        if (exit) {
            System.exit(0);
        }
    }

    Parameters(String[] args) {
        this(args, SystemExit.SYSTEM_EXIT);
    }

    Parameters(String[] args, IExitHandler systemExitHandler) {
        try {
            this.initParametersFromProperties();
            this.parser.parseArgument(args);
            ThreadParameters[] threadParametersArray = this.threads;
            int n = this.threads.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadParameters thread = threadParametersArray[n2];
                thread.check();
                ++n2;
            }
            if (this.serverURL == null) {
                throw new ConfigurationFailureException("No 'server-url' defined.");
            }
        }
        catch (Exception ex) {
            this.outputException(ex);
            systemExitHandler.exit(1);
            throw new AssertionError((Object)ex.getMessage());
        }
    }

    private void initParametersFromProperties() {
        this.serviceProperties = this.loadServiceProperties();
        this.processorProperties = Parameters.extractProcessorProperties(this.serviceProperties);
        this.threads = Parameters.createThreadParameters(this.serviceProperties);
        this.serverURL = this.serviceProperties.getProperty("server-url");
        this.username = this.serviceProperties.getProperty("username");
        this.password = this.serviceProperties.getProperty("password");
        this.checkIntervalSeconds = Long.parseLong(this.serviceProperties.getProperty("check-interval", "120"));
        this.shutdownTimeOutSeconds = Long.parseLong(this.serviceProperties.getProperty("shutdown-timeout", "30"));
        this.highwaterMarkKb = Long.parseLong(this.serviceProperties.getProperty("highwater-mark", "0"));
        this.sendNotificationOnSuccessFullRegistration = Boolean.parseBoolean(this.serviceProperties.getProperty("notify-successful-registration", "false"));
        this.mailProperties = Parameters.createMailProperties(this.serviceProperties);
    }

    private static Map<String, Properties> extractProcessorProperties(Properties properties) {
        LinkedHashMap<String, Properties> map = new LinkedHashMap<String, Properties>();
        String processors = properties.getProperty("processors");
        if (processors != null) {
            String[] procedureTypes;
            String[] stringArray = procedureTypes = processors.split(ITEMS_DELIMITER);
            int n = procedureTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String procedureType = stringArray[n2];
                String prefix = "processor." + procedureType + ".";
                map.put(procedureType, ExtendedProperties.getSubset(properties, prefix, true));
                ++n2;
            }
        }
        return map;
    }

    private static ThreadParameters[] createThreadParameters(Properties serviceProperties) {
        String threadNames = serviceProperties.getProperty(INPUT_THREAD_NAMES);
        if (threadNames == null) {
            return new ThreadParameters[]{new ThreadParameters(serviceProperties, "default")};
        }
        String[] names = threadNames.split(ITEMS_DELIMITER);
        Parameters.validateThreadNames(names);
        return Parameters.createThreadParameters(names, serviceProperties);
    }

    private static ThreadParameters[] createThreadParameters(String[] names, Properties serviceProperties) {
        ThreadParameters[] threadParameters = new ThreadParameters[names.length];
        Properties generalProperties = Parameters.removeThreadSpecificProperties(names, serviceProperties);
        int i = 0;
        while (i < names.length) {
            String name = names[i].trim();
            if (operationLog.isInfoEnabled()) {
                operationLog.info("Create parameters for thread '" + name + "'.");
            }
            ExtendedProperties threadProperties = ExtendedProperties.getSubset(serviceProperties, Parameters.getPropertyPrefix(name), true);
            threadProperties.putAll((Map<?, ?>)generalProperties);
            threadParameters[i] = new ThreadParameters(threadProperties, name);
            ++i;
        }
        return threadParameters;
    }

    private static Properties removeThreadSpecificProperties(String[] names, Properties properties) {
        ExtendedProperties generalProperties = ExtendedProperties.createWith(properties);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            generalProperties.removeSubset(Parameters.getPropertyPrefix(name));
            ++n2;
        }
        return generalProperties;
    }

    private static String getPropertyPrefix(String name) {
        return String.valueOf(name) + ".";
    }

    private static void validateThreadNames(String[] names) {
        HashSet<String> processed = new HashSet<String>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (processed.contains(name)) {
                throw new ConfigurationFailureException("Duplicated thread name: " + name);
            }
            if (name.length() == 0) {
                throw new ConfigurationFailureException("Thread name:cannot be empty!");
            }
            processed.add(name);
            ++n2;
        }
    }

    private static final Properties createMailProperties(Properties serviceProperties) {
        ExtendedProperties properties = ExtendedProperties.getSubset(serviceProperties, "mail", false);
        if (((Properties)properties).getProperty("mail.smtp.host") == null) {
            properties.setProperty("mail.smtp.host", "localhost");
        }
        if (((Properties)properties).getProperty("mail.from") == null) {
            properties.setProperty("mail.from", "etlserver@localhost");
        }
        return properties;
    }

    private void outputException(Exception ex) {
        if (ex instanceof UserFailureException || ex instanceof CmdLineException) {
            System.err.println(ex.getMessage());
        } else {
            System.err.println("An exception occurred.");
            ex.printStackTrace();
        }
        if (ex instanceof CmdLineException) {
            this.printHelp(false);
        }
    }

    private Properties loadServiceProperties() {
        Properties properties;
        Properties properties2 = new Properties();
        FileInputStream is = new FileInputStream(SERVICE_PROPERTIES_FILE);
        try {
            properties2.load(is);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            catch (Exception ex) {
                operationLog.warn("Could not load the service properties from resource 'etc/service.properties'.", ex);
                throw new ConfigurationFailureException("Could not load the service properties from resource 'etc/service.properties'.", ex);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return properties;
    }

    public long getCheckIntervalMillis() {
        return this.checkIntervalSeconds * 1000L;
    }

    public long getShutdownTimeOutMillis() {
        return this.shutdownTimeOutSeconds * 1000L;
    }

    public long getHighwaterMarkKb() {
        return this.highwaterMarkKb;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public final Properties getProperties() {
        return this.serviceProperties;
    }

    public final Map<String, Properties> getProcessorProperties() {
        return this.processorProperties;
    }

    public final Properties getMailProperties() {
        return this.mailProperties;
    }

    public void log() {
        if (operationLog.isInfoEnabled()) {
            ThreadParameters[] threadParametersArray = this.threads;
            int n = this.threads.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadParameters threadParameters = threadParametersArray[n2];
                threadParameters.log();
                ++n2;
            }
            operationLog.info(String.format("Check intervall: %d s.", this.getCheckIntervalMillis() / 1000L));
        }
    }

    public boolean isSendNotificationOnSuccessFullRegistration() {
        return this.sendNotificationOnSuccessFullRegistration;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public ThreadParameters[] getThreads() {
        return this.threads;
    }
}

