/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ILineTokenizer;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLineTokenizer
implements ILineTokenizer {
    private final Map<PropertyKey, String> properties = new EnumMap<PropertyKey, String>(PropertyKey.class);
    private static final Map<PropertyKey, StrMatcher> defaultStrMatchers = DefaultLineTokenizer.createDefaultStrMatchers();
    private StrTokenizer tokenizer;

    private static final Map<PropertyKey, StrMatcher> createDefaultStrMatchers() {
        EnumMap<PropertyKey, StrMatcher> map = new EnumMap<PropertyKey, StrMatcher>(PropertyKey.class);
        map.put(PropertyKey.SEPARATOR_CHARS, StrMatcher.tabMatcher());
        map.put(PropertyKey.QUOTE_CHARS, StrMatcher.noneMatcher());
        map.put(PropertyKey.TRIMMER_CHARS, StrMatcher.trimMatcher());
        map.put(PropertyKey.IGNORED_CHARS, StrMatcher.noneMatcher());
        return map;
    }

    public final void setProperty(PropertyKey key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.properties.remove((Object)key);
        }
        this.properties.put(key, value);
        if (this.tokenizer != null) {
            StrMatcher matcher = this.getStrMatcher(key);
            if (key == PropertyKey.SEPARATOR_CHARS) {
                this.tokenizer.setDelimiterMatcher(matcher);
            } else if (key == PropertyKey.QUOTE_CHARS) {
                this.tokenizer.setQuoteMatcher(matcher);
            } else if (key == PropertyKey.TRIMMER_CHARS) {
                this.tokenizer.setTrimmerMatcher(matcher);
            } else if (key == PropertyKey.IGNORED_CHARS) {
                this.tokenizer.setIgnoredMatcher(matcher);
            }
        }
    }

    private final StrMatcher getStrMatcher(PropertyKey key) {
        StrMatcher strMatcher = defaultStrMatchers.get((Object)key);
        String value = this.properties.get((Object)key);
        if (value != null) {
            strMatcher = StrMatcher.charSetMatcher(value);
        }
        return strMatcher;
    }

    @Override
    public final void init() {
        StrTokenizer strTokenizer = new StrTokenizer();
        strTokenizer.setDelimiterMatcher(this.getStrMatcher(PropertyKey.SEPARATOR_CHARS));
        strTokenizer.setQuoteMatcher(this.getStrMatcher(PropertyKey.QUOTE_CHARS));
        strTokenizer.setTrimmerMatcher(this.getStrMatcher(PropertyKey.TRIMMER_CHARS));
        strTokenizer.setIgnoredMatcher(this.getStrMatcher(PropertyKey.IGNORED_CHARS));
        strTokenizer.setEmptyTokenAsNull(false);
        strTokenizer.setIgnoreEmptyTokens(false);
        this.tokenizer = strTokenizer;
    }

    @Override
    public final String[] tokenize(String line) {
        return this.tokenizer.reset(line).getTokenArray();
    }

    @Override
    public final void destroy() {
        this.tokenizer = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKey {
        SEPARATOR_CHARS,
        QUOTE_CHARS,
        IGNORED_CHARS,
        TRIMMER_CHARS;

    }
}

