/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.MappedProperty;
import ch.systemsx.cisd.common.utilities.StringUtilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyMapper
implements IPropertyMapper {
    private final TableMap<String, IPropertyModel> propertyModels;

    public DefaultPropertyMapper(String[] properties) throws IllegalArgumentException {
        assert (properties != null) : "Unspecified properties";
        this.propertyModels = new TableMap<String, IPropertyModel>(new IKeyExtractor<String, IPropertyModel>(){

            @Override
            public final String getKey(IPropertyModel e) {
                return e.getName().toLowerCase();
            }
        });
        this.tokensToMap(properties);
    }

    private final void tokensToMap(String[] properties) throws IllegalArgumentException {
        int len = properties.length;
        int i = 0;
        while (i < len) {
            String token = properties[i];
            if (StringUtils.isBlank(token)) {
                throw new IllegalArgumentException(String.format("%s token of %s is blank.", StringUtilities.getOrdinal(i), Arrays.asList(properties)));
            }
            this.propertyModels.add(new MappedProperty(i, token));
            ++i;
        }
    }

    @Override
    public final boolean containsPropertyName(String propertyName) {
        return this.propertyModels.tryGet(propertyName.toLowerCase()) != null;
    }

    @Override
    public final Set<String> getAllPropertyNames() {
        return new TreeSet<String>((Collection)this.propertyModels.keySet());
    }

    @Override
    public final IPropertyModel getPropertyModel(String propertyName) throws IllegalArgumentException {
        if (!this.containsPropertyName(propertyName)) {
            throw new IllegalArgumentException(String.format("Given property name '%s' does not exist.", propertyName));
        }
        return this.propertyModels.tryGet(propertyName.toLowerCase());
    }
}

