/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.db.SQLStateUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBUtilities {
    private DBUtilities() {
    }

    public static boolean isDBNotExistException(DataAccessException ex) {
        return SQLStateUtils.isInvalidCatalogName(SQLStateUtils.getSqlState(ex));
    }

    public static boolean isDuplicateObjectException(DataAccessException ex) {
        return SQLStateUtils.isDuplicateObject(SQLStateUtils.getSqlState(ex));
    }

    public static boolean isDuplicateDatabaseException(DataAccessException ex) {
        return SQLStateUtils.isDuplicateDatabase(SQLStateUtils.getSqlState(ex));
    }

    public static final List<String> splitSqlStatements(String sqlScript) {
        String[] lines = StringUtils.split(sqlScript, '\n');
        ArrayList<String> statements = new ArrayList<String>(lines.length);
        StringBuilder statement = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            int commentStart = line.indexOf("--");
            if (commentStart >= 0) {
                line = line.substring(0, commentStart);
            }
            int startIdx = 0;
            int endIdx = line.indexOf(59) + 1;
            while (endIdx > 0) {
                statement.append(line.substring(startIdx, endIdx).trim());
                DBUtilities.addToStatements(statements, statement);
                startIdx = endIdx;
                endIdx = line.indexOf(59, startIdx) + 1;
            }
            statement.append(line.substring(startIdx).trim());
            statement.append(' ');
            if (statement.length() > 1 && statement.charAt(statement.length() - 2) == ';') {
                DBUtilities.addToStatements(statements, statement);
            }
            ++i;
        }
        return statements;
    }

    private static final void addToStatements(List<String> statements, StringBuilder statement) {
        String statementStr = statement.toString().trim().replaceAll("\\s+", " ").replaceAll("\\)(\\w)", ") $1").replaceAll("\\s+;", ";");
        statements.add(statementStr);
        statement.setLength(0);
    }
}

