/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base.properties;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertyValue;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityPropertiesSchema
extends AbstractHashable
implements IEntityPropertiesSchema {
    private final Map<String, EntityPropertySchema> schema = new LinkedHashMap<String, EntityPropertySchema>();

    private EntityPropertiesSchema() {
    }

    public static IEntityPropertiesSchema create(List<EntityPropertySchema> propertyTypes) {
        EntityPropertiesSchema schema = new EntityPropertiesSchema();
        for (EntityPropertySchema entityPropertySchema : propertyTypes) {
            schema.addPropertySchema(entityPropertySchema);
        }
        return schema;
    }

    public static IEntityPropertiesSchema createFromSimple(SimpleEntityPropertySchema[] simpleSchema) {
        if (simpleSchema == null) {
            return null;
        }
        EntityPropertiesSchema schema = new EntityPropertiesSchema();
        SimpleEntityPropertySchema[] simpleEntityPropertySchemaArray = simpleSchema;
        int n = simpleSchema.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleEntityPropertySchema prop = simpleEntityPropertySchemaArray[n2];
            schema.addPropertySchema(EntityPropertySchema.createFromSimple(prop));
            ++n2;
        }
        return schema;
    }

    public static EntityPropertiesSchema createEmpty() {
        return new EntityPropertiesSchema();
    }

    public EntityPropertySchema addPropertySchema(long id, boolean isMandatory, Date registrationDate, Person registrator, PropertyType propertyType) {
        EntityPropertySchema entityPropertySchema = new EntityPropertySchema(id, isMandatory, registrationDate, registrator, propertyType);
        this.addPropertySchema(entityPropertySchema);
        return entityPropertySchema;
    }

    private void addPropertySchema(EntityPropertySchema entityPropertySchema) {
        String propertyName = entityPropertySchema.getCode();
        if (this.schema.get(propertyName) != null) {
            throw new IllegalArgumentException("property already present: " + propertyName);
        }
        this.schema.put(propertyName, entityPropertySchema);
    }

    public EntityPropertySchema tryGetPropertySchema(String propertyName) {
        return this.schema.get(propertyName);
    }

    private static UserFailureException createMandatoryException(String name) {
        return UserFailureException.fromTemplate("Property '%s' is mandatory and cannot be set to the empty value.", name);
    }

    @Override
    public boolean hasPropertySchema(String name) {
        return this.schema.containsKey(name);
    }

    @Override
    public EntityPropertySchema getPropertySchema(String propertyName) {
        EntityPropertySchema type = this.tryGetPropertySchema(propertyName);
        if (type == null) {
            throw UserFailureException.fromTemplate("Unknown property name '%s'", propertyName);
        }
        return type;
    }

    @Override
    public String[] getAllNames() {
        return this.schema.keySet().toArray(new String[0]);
    }

    @Override
    public SimpleEntityPropertySchema[] createSimple() {
        Set<String> allNames = this.schema.keySet();
        SimpleEntityPropertySchema[] result = new SimpleEntityPropertySchema[allNames.size()];
        int i = 0;
        for (String name : allNames) {
            EntityPropertySchema orig = this.getPropertySchema(name);
            result[i] = orig.createSimple();
            ++i;
        }
        return result;
    }

    @Override
    public EntityPropertyValue validateAndCreateValue(String name, String untypedValueOrNull) {
        EntityPropertySchema propertySchema = this.getPropertySchema(name);
        assert (propertySchema != null);
        if (propertySchema.getIsMandatory() && untypedValueOrNull == null) {
            throw EntityPropertiesSchema.createMandatoryException(name);
        }
        return EntityPropertyValue.createFromUntyped(untypedValueOrNull, propertySchema.getDataTypeCode());
    }
}

