/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.annotation.BeanProperty;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.base.NewSampleComponentWithFixedMaterialType;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesFileParameters;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesSetter;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.factory.NewSampleComponentFactory;
import ch.systemsx.cisd.lims.client.commands.factory.NewSampleComponentWithFixedMaterialTypeFactory;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegisterTopPlateCommand
extends AbstractCommandWithSessionToken {
    private static final String CODE = "code";
    private static final String VALUE = "value";
    private final BisTabFileLoader<NewSampleComponent> tabFileLoader;
    private final BisTabFileLoader<NewSampleComponentWithFixedMaterialType> tabFileLoaderWithFixedMaterialType;
    private SampleTypeCode sampleTypeCode;

    protected AbstractRegisterTopPlateCommand(String name, SampleTypeCode sampleTypeCode) {
        super(name);
        assert (sampleTypeCode != null) : "Unspecified sample type code.";
        this.sampleTypeCode = sampleTypeCode;
        IParserObjectFactoryFactory<NewSampleComponentWithFixedMaterialType> factoryWithFixedMaterialType = new IParserObjectFactoryFactory<NewSampleComponentWithFixedMaterialType>(){

            @Override
            public final IParserObjectFactory<NewSampleComponentWithFixedMaterialType> createFactory(IPropertyMapper propertyMapper) {
                return NewSampleComponentWithFixedMaterialTypeFactory.createInstance(propertyMapper);
            }
        };
        this.tabFileLoaderWithFixedMaterialType = new BisTabFileLoader<NewSampleComponentWithFixedMaterialType>(factoryWithFixedMaterialType);
        IParserObjectFactoryFactory<NewSampleComponent> factory = new IParserObjectFactoryFactory<NewSampleComponent>(){

            @Override
            public final IParserObjectFactory<NewSampleComponent> createFactory(IPropertyMapper propertyMapper) {
                return NewSampleComponentFactory.createInstance(propertyMapper);
            }
        };
        this.tabFileLoader = new BisTabFileLoader<NewSampleComponent>(factory);
    }

    protected final NewSampleComponentWithFixedMaterialType[] loadSampleComponentsWithFixedMaterialTypeFromTabFile(File file) {
        List<NewSampleComponentWithFixedMaterialType> list = this.tabFileLoaderWithFixedMaterialType.load(file);
        return list.toArray(NewSampleComponentWithFixedMaterialType.EMPTY_ARRAY);
    }

    protected final NewSampleComponent[] loadSampleComponentsFromTabFile(File fileOrNull) {
        if (fileOrNull == null) {
            return NewSampleComponent.EMPTY_ARRAY;
        }
        List<NewSampleComponent> list = this.tabFileLoader.load(fileOrNull);
        return list.toArray(NewSampleComponent.EMPTY_ARRAY);
    }

    protected static final String getSampleCode(String canonicalPath) {
        return FilenameUtils.getBaseName((String)canonicalPath);
    }

    protected SimpleEntityProperty[] getPropertyValues(String sessionToken, ILIMSService limsService, AbstractPropertiesFileParameters parameters) {
        String code = this.sampleTypeCode.getCode();
        SimpleEntityPropertySchema[] simpleSchema = limsService.listEntityPropertyTypes(sessionToken, EntityKind.SAMPLE, code);
        IEntityPropertiesSchema schema = EntityPropertiesSchema.createFromSimple(simpleSchema);
        List<KeyValuePair> list = this.loadProperties(parameters);
        TopPlatePropertiesSetter propertiesSetter = new TopPlatePropertiesSetter(schema);
        for (KeyValuePair keyValuePair : list) {
            propertiesSetter.setProperty(keyValuePair.getKey(), keyValuePair.getValue());
        }
        String propertyKeyValuePair = parameters.getPropertyKeyValuePair();
        if (propertyKeyValuePair != null) {
            int indexOfEqualSign = propertyKeyValuePair.indexOf(61);
            if (indexOfEqualSign < 0) {
                throw new UserFailureException("Missing '=' in the property option: " + propertyKeyValuePair);
            }
            String key = propertyKeyValuePair.substring(0, indexOfEqualSign).trim();
            String value = propertyKeyValuePair.substring(indexOfEqualSign + 1).trim();
            propertiesSetter.setProperty(key, value);
        }
        return ((NewSample)propertiesSetter.getConstructedObject()).getProperties();
    }

    private List<KeyValuePair> loadProperties(AbstractPropertiesFileParameters parameters) {
        IParserObjectFactoryFactory<KeyValuePair> factoryFactory = new IParserObjectFactoryFactory<KeyValuePair>(){

            @Override
            public IParserObjectFactory<KeyValuePair> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new AbstractParserObjectFactory<KeyValuePair>(KeyValuePair.class, propertyMapper){};
            }
        };
        BisTabFileLoader<KeyValuePair> loader = new BisTabFileLoader<KeyValuePair>(factoryFactory);
        String propertiesFileOrNull = parameters.getPropertiesFile();
        List<KeyValuePair> list = propertiesFileOrNull == null ? loader.load(new StringReader("code\tvalue\n")) : loader.load(Utilities.getFileCheckAccesible(propertiesFileOrNull));
        return list;
    }

    public static final class KeyValuePair {
        private String key;
        private String value;

        public final String getKey() {
            return this.key;
        }

        @BeanProperty(label="code")
        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @BeanProperty(label="value")
        public final void setValue(String value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TopPlatePropertiesSetter
    extends AbstractPropertiesSetter<NewSample> {
        TopPlatePropertiesSetter(IEntityPropertiesSchema schema) {
            super(schema);
        }

        @Override
        protected final NewSample createEntityPropertiesHolder() {
            return new NewSample();
        }

        @Override
        protected final boolean setSpecificProperty(String name, String valueOrNull) {
            return false;
        }

        @Override
        protected List<String> getMandatorySpecificColumns(boolean onlyMissing) {
            return new ArrayList<String>();
        }
    }
}

