/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.client.commands.AbstractAssignPropertyTypeCommand;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import java.io.IOException;
import jline.ConsoleReader;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

abstract class AbstractUnassignPropertyTypeCommand
extends AbstractCommandWithSessionToken {
    private static final String COMMAND_NAME_FORMAT = "unassign-%s-property-type";
    final EntityKind entityKind;
    private static final String CONFIRM_UNASSIGNMENT_FMT = "This will remove %d %s property values. Do you want to proceed? (y/n [n]) ";
    private static final String NO_ACTION_UNDERTAKEN = "No action has been undertaken.";
    static final String REMOVED_PROPERTY_VALUES_FMT = " %d %s property values has(have) been removed from the database.";
    static final String UNASSIGN_SUCCESSFUL_FMT = "Property type '%s' has been successfully unassigned from %ss of type '%s'.";

    AbstractUnassignPropertyTypeCommand(String entityKindLabel, EntityKind entityKind) {
        super(AbstractUnassignPropertyTypeCommand.getCommandName(entityKindLabel, entityKind));
        this.entityKind = entityKind;
    }

    private static final String getCommandName(String entityKindLabel, EntityKind entityKind) {
        return String.format(COMMAND_NAME_FORMAT, entityKindLabel == null ? entityKind.getLabel() : entityKindLabel);
    }

    UnassignPropertyTypeParameters createParameters(String[] arguments) {
        return new UnassignPropertyTypeParameters(arguments, AbstractAssignPropertyTypeCommand.AbstractAssignPropertyTypeParameters.getEntityCodeGenericArgLabel(this.entityKind));
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        ILIMSService limsService;
        String entityTypeCode;
        UnassignPropertyTypeParameters parameters = this.createParameters(arguments);
        String propertyType = parameters.getPropertyName();
        long numberOfEntities = this.getNumberOfEntities(sessionToken, propertyType, entityTypeCode = this.getEntityTypeCode(parameters), limsService = this.getLIMSService(parameters));
        if (numberOfEntities > 0L && !parameters.isForce() && !this.confirmUnassigment(numberOfEntities)) {
            System.out.println(String.format(NO_ACTION_UNDERTAKEN, new Object[0]));
            return 0;
        }
        limsService.unassignEntityPropertyType(sessionToken, this.entityKind, entityTypeCode, propertyType);
        System.out.println(String.format(UNASSIGN_SUCCESSFUL_FMT, propertyType, this.entityKind.getLabel(), entityTypeCode));
        if (numberOfEntities > 0L) {
            System.out.println(String.format(REMOVED_PROPERTY_VALUES_FMT, numberOfEntities, this.entityKind.getLabel()));
        }
        return 0;
    }

    abstract String getEntityTypeCode(IEntityTypeCodeProvider var1) throws UserFailureException;

    private long getNumberOfEntities(String sessionToken, String propertyType, String entityTypeCode, ILIMSService limsService) {
        return limsService.countPropertyTypedEntities(sessionToken, this.entityKind, entityTypeCode, propertyType);
    }

    private final boolean confirmUnassigment(long size) {
        ConsoleReader reader = this.getConsoleReader();
        try {
            String confirmPrompt = String.format(CONFIRM_UNASSIGNMENT_FMT, size, this.entityKind.getLabel());
            String readLine = StringUtils.trimToEmpty(reader.readLine(confirmPrompt));
            if (readLine.length() > 0) {
                return readLine.toLowerCase().charAt(0) == 'y';
            }
            return false;
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("Could not read line using ConsoleReader.", ex);
        }
    }

    class UnassignPropertyTypeParameters
    extends AbstractParameters
    implements IEntityTypeCodeProvider {
        @Option(longName="force", usage="Attempt to unassign the property type without prompting for confirmation.")
        private boolean force;

        UnassignPropertyTypeParameters(String[] args) {
            this(args, null);
        }

        UnassignPropertyTypeParameters(String[] args, String entityCodeGenericArgLabel) {
            super(args, AbstractUnassignPropertyTypeCommand.this.getName(), AbstractAssignPropertyTypeCommand.AbstractAssignPropertyTypeParameters.getGenericArgs(entityCodeGenericArgLabel, "<property-code>"));
            int size = this.getArgs().size();
            int count = this.getArgCount();
            if (size < count) {
                System.err.println(this.getTooFewArgumentsErrorMessage());
                this.printHelp(true);
            }
            if (size > count) {
                System.err.println("Too many parameters");
                this.printHelp(true);
            }
        }

        private final String getPropertyName() {
            return this.getArgs().get(this.getArgCount() - 1);
        }

        int getArgCount() {
            return 2;
        }

        String getTooFewArgumentsErrorMessage() {
            return "Specify the " + AbstractUnassignPropertyTypeCommand.this.entityKind.getLabel() + " type and the code of the property, which should be assigned to it!";
        }

        final boolean isForce() {
            return this.force;
        }

        public String getEntityTypeCode() {
            return this.getArgs().get(0);
        }
    }
}

