/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractExperimentParameters;
import org.kohsuke.args4j.Option;

public class InvalidateExperimentCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "invalidate-experiment";
    private static InvalidateExperimentCommand instance;

    public static final synchronized InvalidateExperimentCommand getInstance() {
        if (instance == null) {
            instance = new InvalidateExperimentCommand();
        }
        return instance;
    }

    private InvalidateExperimentCommand() {
        super(NAME);
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(parameters.getProjectCode(), parameters.getExperimentCode());
        limsService.invalidateExperiment(sessionToken, experimentIdentifier, parameters.getInvalidationReason());
        System.out.println("Experiment " + experimentIdentifier + " successfully invalidated.");
        return 0;
    }

    private static final class Parameters
    extends AbstractExperimentParameters {
        @Option(name="r", longName="invalidation-reason", metaVar="<invalidation-reason>", usage="Description of the invalidation reason")
        private String invalidationReason;

        public Parameters(String[] args) {
            super(args, InvalidateExperimentCommand.NAME, "<project-code> <experiment-code>");
            if (this.getArgs().size() < 2) {
                System.err.println("Exactly one <project-code> and at least one <experiment-code> needs to be specified.");
                this.printHelp(true);
            }
        }

        public final String getInvalidationReason() {
            return this.invalidationReason;
        }
    }
}

