/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.ILinePrinter;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleFilter;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.EntityTypeUtils;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;
import ch.systemsx.cisd.lims.client.commands.ListControlLayoutsCommand;
import ch.systemsx.cisd.lims.client.model.SampleTableModel;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.parameters.PatternAndLimitParameters;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.kohsuke.args4j.Option;

public class ListPlatesCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list-plates";
    private static ListPlatesCommand instance;

    private ListPlatesCommand() {
        this(NAME);
    }

    ListPlatesCommand(String name) {
        super(name);
    }

    public static synchronized ListPlatesCommand getInstance() {
        if (instance == null) {
            instance = new ListPlatesCommand();
        }
        return instance;
    }

    private static final StringBuilder getNoSampleFoundOutput(SampleTypeCode sampleType, SampleFilter sampleFilter) {
        StringBuilder builder = new StringBuilder();
        builder.append("No " + sampleType.getDescription());
        String[] patterns = sampleFilter.getPatterns();
        if (patterns.length > 0) {
            builder.append(" with patterns '").append(CollectionUtils.abbreviate(patterns, -1)).append("'");
        }
        if (sampleFilter.isNotRegisteredToExperiment()) {
            builder.append(" not registered to an experiment");
        }
        builder.append(" has been found in the database.");
        return builder;
    }

    SampleTypeCode getSampleTypeCode(IEntityTypeCodeProvider parameters) {
        return EntityTypeUtils.getPlateTypeCode(parameters, ListControlLayoutsCommand.getInstance());
    }

    protected final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        ListSamplesParameters parameters = this.createParameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        SampleFilter sampleFilter = parameters.getSampleFilter();
        SampleTypeCode sampleTypeCode = this.getSampleTypeCode(parameters);
        Object[] samples = limsService.listSamples(sessionToken, sampleTypeCode.getCode(), sampleFilter, parameters.getLimitFilter(), sampleTypeCode.isParentRequired());
        int len = samples.length;
        if (len == 0 && parameters.isPrettyPrinted()) {
            StringBuilder builder = ListPlatesCommand.getNoSampleFoundOutput(sampleTypeCode, sampleFilter);
            System.out.println(builder);
            return 0;
        }
        Arrays.sort(samples);
        String header = WordUtils.capitalize(String.valueOf(sampleTypeCode.getDescription()) + "s");
        SampleTableModel model = new SampleTableModel((Sample[])samples, header, parameters.isPrettyPrinted());
        ILinePrinter linePrinter = this.createPrinter(parameters);
        IOutputPrinter outputPrinter = ListPlatesCommand.createPrinter(parameters, linePrinter, "");
        outputPrinter.printTableModel(model, "");
        return 0;
    }

    ListSamplesParameters createParameters(String[] arguments) {
        return new Parameters(arguments);
    }

    static abstract class ListSamplesParameters
    extends PatternAndLimitParameters
    implements IEntityTypeCodeProvider {
        ListSamplesParameters(String[] args, String limsCommand, String genericArgs) {
            super(args, limsCommand, genericArgs, 1);
        }
    }

    private static final class Parameters
    extends ListSamplesParameters {
        @Option(name="n", longName="no-experiment", usage="List only plates not registered to an experiment")
        private Boolean notRegisteredToExperiment;
        @Option(name="a", longName="show-also-invalid", usage="Returned results will contain also invalid plates")
        private Boolean showInvalidated;
        private static final String SAMPLE_TYPE_CODE_GENERIC_ARG = "<plate-type-code> [<plate-code pattern(s)>]";

        Parameters(String[] args) {
            super(args, ListPlatesCommand.NAME, SAMPLE_TYPE_CODE_GENERIC_ARG);
            if (this.getArgs().size() < 1) {
                System.err.println("At least the <plate-type-code> [<plate-code pattern(s)>] needs to be specified.");
                this.printHelp(true);
            }
        }

        final boolean getHideInvalidated() {
            return this.showInvalidated == null;
        }

        final boolean isNotRegisteredToExperiment() {
            return this.notRegisteredToExperiment != null && this.notRegisteredToExperiment != false;
        }

        public final String getEntityTypeCode() {
            return StringUtils.upperCase(this.getArgs().get(0));
        }

        public final SampleFilter getSampleFilter() {
            return new SampleFilter(super.getSampleFilter(), this.isNotRegisteredToExperiment(), this.getHideInvalidated());
        }
    }
}

