/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.PropertyTypeTableModel;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;

public final class ListPropertyTypesCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list-property-types";
    private static ListPropertyTypesCommand instance;

    private ListPropertyTypesCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        OutputTypeParameters parameters = new OutputTypeParameters(arguments, this.getName());
        ILIMSService limsService = this.getLIMSService(parameters);
        PropertyType[] propertyTypes = limsService.listPropertyTypes(sessionToken);
        if (propertyTypes.length == 0 && parameters.isPrettyPrinted()) {
            System.out.println("No property types found.");
        } else {
            this.printTable(new PropertyTypeTableModel(propertyTypes, parameters.isPrettyPrinted()), parameters);
        }
        return 0;
    }

    public static final synchronized ListPropertyTypesCommand getInstance() {
        if (instance == null) {
            instance = new ListPropertyTypesCommand();
        }
        return instance;
    }
}

