/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommand;
import ch.systemsx.cisd.lims.client.parameters.EmptyParameters;
import ch.systemsx.cisd.lims.client.utilities.Constants;

public final class LogoutCommand
extends AbstractCommand {
    private static final String NAME = "logout";
    private static LogoutCommand instance;

    private LogoutCommand() {
        super(NAME);
    }

    public static final synchronized LogoutCommand getInstance() {
        if (instance == null) {
            instance = new LogoutCommand();
        }
        return instance;
    }

    public final int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        if (Constants.SESSION_TOKEN_FILE.exists()) {
            String sessionToken = FileUtilities.loadToString(Constants.SESSION_TOKEN_FILE).trim();
            EmptyParameters parameters = new EmptyParameters(arguments, NAME);
            ILIMSService limsService = this.getLIMSService(parameters);
            limsService.closeSession(sessionToken);
            Constants.SESSION_TOKEN_FILE.delete();
            System.out.println("Successfully logged out.");
        }
        return 0;
    }
}

