/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Procedure;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentDatasetTableModel
extends ModalTableModel {
    private final ExternalDataWithSample[] externalData;

    public ExperimentDatasetTableModel(Procedure[] procedures, boolean prettyMode) {
        super(prettyMode);
        this.externalData = ExperimentDatasetTableModel.convertToExternalDataWithSample(procedures);
    }

    private static ExternalDataWithSample[] convertToExternalDataWithSample(Procedure[] procedures) {
        assert (procedures != null);
        ArrayList<ExternalDataWithSample> list = new ArrayList<ExternalDataWithSample>();
        Procedure[] procedureArray = procedures;
        int n = procedures.length;
        int n2 = 0;
        while (n2 < n) {
            Procedure procedure = procedureArray[n2];
            Sample[] sampleArray = procedure.getResultSamples();
            int n3 = sampleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ExternalData externalData;
                Sample sample = sampleArray[n4];
                ExternalData[] externalDataArray = sample.getDerivedData();
                int n5 = externalDataArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    externalData = externalDataArray[n6];
                    list.add(new ExternalDataWithSample(externalData, sample, true));
                    ++n6;
                }
                externalDataArray = sample.getMeasurementData();
                n5 = externalDataArray.length;
                n6 = 0;
                while (n6 < n5) {
                    externalData = externalDataArray[n6];
                    list.add(new ExternalDataWithSample(externalData, sample, false));
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new ExternalDataWithSample[list.size()]);
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 4: 
            case 5: 
            case 6: {
                return Boolean.class;
            }
            case 9: 
            case 11: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getHeader() {
        return "";
    }

    @Override
    public int getRowCount() {
        return this.externalData.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.PROCEDURE_TYPE.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.PLATE.getName(this.prettyMode);
            }
            case 3: {
                return FieldName.PLATE_TYPE.getName(this.prettyMode);
            }
            case 4: {
                return FieldName.DERIVED.getName(this.prettyMode);
            }
            case 5: {
                return FieldName.IS_COMPLETE.getName(this.prettyMode);
            }
            case 6: {
                return FieldName.INVALID.getName(this.prettyMode);
            }
            case 7: {
                return FieldName.OBSERVABLE_TYPE.getName(this.prettyMode);
            }
            case 8: {
                return FieldName.FILE_FORMAT.getName(this.prettyMode);
            }
            case 9: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
            case 10: {
                return FieldName.RELATIVE_LOCATION.getName(this.prettyMode);
            }
            case 11: {
                return FieldName.MEASUREMENT_TIMESTAMP.getName(this.prettyMode);
            }
            case 12: {
                return FieldName.PARENT_DATASET.getName(this.prettyMode);
            }
            case 13: {
                return FieldName.DATA_PRODUCER.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ExternalDataWithSample data = this.externalData[rowIndex];
        switch (columnIndex) {
            case 0: {
                return data.getExternalData().getCode();
            }
            case 1: {
                return data.getExternalData().getProcedure().getProcedureType().getCode();
            }
            case 2: {
                return data.getSample().getCode();
            }
            case 3: {
                return data.getSample().getSampleType().getCode();
            }
            case 4: {
                return data.isDerived();
            }
            case 5: {
                return ExperimentDatasetTableModel.getIsCompleteOutput(data.getExternalData().getComplete());
            }
            case 6: {
                if (data.getSample().getInvalidation() != null) {
                    return true;
                }
                return false;
            }
            case 7: {
                return data.getExternalData().getObservableType().getCode();
            }
            case 8: {
                return data.getExternalData().getFileFormatType().getCode();
            }
            case 9: {
                return data.getExternalData().getRegistrationDate();
            }
            case 10: {
                return data.getExternalData().getLocation();
            }
            case 11: {
                return data.getExternalData().getProductionDate();
            }
            case 12: {
                return data.getExternalData().getParentDataSetCode();
            }
            case 13: {
                return data.getExternalData().getDataProducerCode();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    private static Object getIsCompleteOutput(BooleanOrUnknown booleanOrUnknown) {
        if (booleanOrUnknown == BooleanOrUnknown.FALSE) {
            return false;
        }
        if (booleanOrUnknown == BooleanOrUnknown.TRUE) {
            return true;
        }
        return null;
    }

    private static class ExternalDataWithSample {
        private final ExternalData externalData;
        private final Sample sample;
        private final boolean isDerived;

        public boolean isDerived() {
            return this.isDerived;
        }

        ExternalDataWithSample(ExternalData externalData, Sample sample, boolean isDerived) {
            this.isDerived = isDerived;
            this.externalData = externalData;
            this.sample = sample;
        }

        private ExternalData getExternalData() {
            return this.externalData;
        }

        private Sample getSample() {
            return this.sample;
        }
    }
}

