/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.ProcessingInstruction;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessingInstructionTableModel
extends ModalTableModel {
    private final ProcessingInstruction[] processingInstructions;

    public ProcessingInstructionTableModel(ProcessingInstruction[] processingInstructions, boolean prettyMode) {
        super(prettyMode);
        assert (processingInstructions != null);
        this.processingInstructions = processingInstructions;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.PROCEDURE_TYPE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.PATH.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.DESCRIPTION.getName(this.prettyMode);
            }
            case 3: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 4: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return Person.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final int getColumnCount() {
        return 5;
    }

    @Override
    public final String getHeader() {
        return "";
    }

    @Override
    public final int getRowCount() {
        return this.processingInstructions.length;
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        ProcessingInstruction processingInstruction = this.processingInstructions[rowIndex];
        switch (columnIndex) {
            case 0: {
                return processingInstruction.getProcedureTypeCode();
            }
            case 1: {
                return processingInstruction.getPath();
            }
            case 2: {
                return processingInstruction.getDescription();
            }
            case 3: {
                return processingInstruction.getRegistrator();
            }
            case 4: {
                return processingInstruction.getRegistrationDate();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }
}

