/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.model.PropertiesDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertySchemaTableModel
extends ModalTableModel {
    private final String header;
    private final List<EntityPropertySchema> schemas;

    public PropertySchemaTableModel(SimpleEntityPropertySchema[] schemas, String header, boolean prettyMode) {
        super(prettyMode);
        this.header = header;
        this.schemas = PropertySchemaTableModel.translate(schemas);
    }

    private static final List<EntityPropertySchema> translate(SimpleEntityPropertySchema[] simpleSchemas) {
        String[] names;
        IEntityPropertiesSchema schema = EntityPropertiesSchema.createFromSimple(simpleSchemas);
        ArrayList<EntityPropertySchema> list = new ArrayList<EntityPropertySchema>();
        String[] stringArray = names = schema.getAllNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            list.add(schema.getPropertySchema(name));
            ++n2;
        }
        Collections.sort(list, new Comparator<EntityPropertySchema>(){

            @Override
            public final int compare(EntityPropertySchema s1, EntityPropertySchema s2) {
                return s1.getCode().compareTo(s2.getCode());
            }
        });
        return list;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.LABEL.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.DATA_TYPE.getName(this.prettyMode);
            }
            case 3: {
                return FieldName.MANDATORY.getName(this.prettyMode);
            }
            case 4: {
                return FieldName.DESCRIPTION.getName(this.prettyMode);
            }
            case 5: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 6: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return Boolean.class;
            }
            case 5: {
                return Person.class;
            }
            case 6: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getColumnCount() {
        return 7;
    }

    @Override
    public final int getRowCount() {
        return this.schemas.size();
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        EntityPropertySchema schema = this.schemas.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return schema.getCode();
            }
            case 1: {
                return schema.getUserLabel();
            }
            case 2: {
                return PropertiesDescriptor.getTypeDescription(schema.getPropertyType());
            }
            case 3: {
                return schema.getIsMandatory();
            }
            case 4: {
                return schema.getDescription();
            }
            case 5: {
                return schema.getRegistrator();
            }
            case 6: {
                return schema.getRegistrationDate();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }
}

