/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.table;

import ch.systemsx.cisd.lims.client.table.ITableModel;
import ch.systemsx.cisd.lims.client.table.TableRenderer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASCIITable {
    private static final char CORNER_CHAR = '+';
    private final ITableModel tableModel;
    private int[] minWidths;
    private int cellPadding;
    private char columnSeparatorChar = (char)124;
    private char rowSeparatorChar = (char)45;
    private boolean bordered = false;
    private Justification columnNameJustification = Justification.LEFT;
    private Justification headerJustification = Justification.CENTER;
    private final String tableComment;

    public ASCIITable(ITableModel tableModel) {
        this(tableModel, "");
    }

    public ASCIITable(ITableModel tableModel, String comment) {
        this.tableModel = tableModel;
        this.setCellPadding(1);
        this.tableComment = comment;
    }

    private final int[] createMinWidths() {
        int headerLength;
        int padding = this.getCellPadding();
        int columnCount = this.tableModel.getColumnCount();
        int[] widths = new int[columnCount];
        int total = 0;
        int col = 0;
        while (col < columnCount) {
            widths[col] = this.tableModel.getColumnName(col).length() + 2 * padding;
            int row = 0;
            while (row < this.tableModel.getRowCount()) {
                String value = this.getRenderedValue(row, col);
                widths[col] = Math.max(widths[col], value.length() + 2 * padding);
                ++row;
            }
            total += widths[col];
            ++col;
        }
        String header = this.tableModel.getHeader();
        if (header != null && total < (headerLength = header.length()) && widths.length > 0) {
            int n = widths.length - 1;
            widths[n] = widths[n] + (headerLength - total);
        }
        return widths;
    }

    private final int getTableWidth() {
        int width = 0;
        int column = 0;
        while (column < this.minWidths.length) {
            width += this.minWidths[column];
            ++column;
        }
        return width + (this.minWidths.length - 1);
    }

    private static final String printText(Justification justification, int columWidth, String text) {
        if (justification == Justification.CENTER) {
            return StringUtils.center(text, columWidth);
        }
        if (justification == Justification.LEFT) {
            return StringUtils.rightPad(text, columWidth);
        }
        return StringUtils.leftPad(text, columWidth);
    }

    protected final String addPadding(String value) {
        return StringUtils.center(value, value.length() + 2 * this.getCellPadding());
    }

    public final int getCellPadding() {
        return this.cellPadding;
    }

    public final void setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
        this.minWidths = this.createMinWidths();
    }

    public final void setColumnSeparatorChar(char columnSeparatorChar) {
        this.columnSeparatorChar = columnSeparatorChar;
    }

    public final char getColumnSeparatorChar() {
        return this.columnSeparatorChar;
    }

    public final void setRowSeparatorChar(char rowSeparatorChar) {
        this.rowSeparatorChar = rowSeparatorChar;
    }

    public final char getRowSeparatorChar() {
        return this.rowSeparatorChar;
    }

    public final boolean isBordered() {
        return this.bordered;
    }

    public final void setBordered(boolean bordered) {
        this.bordered = bordered;
    }

    protected String printHeader() {
        StringBuilder builder = new StringBuilder();
        String header = this.tableModel.getHeader();
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        int tableWidth = this.getTableWidth();
        String text = StringUtils.abbreviate(header, tableWidth);
        builder.append(ASCIITable.printText(this.headerJustification, tableWidth, text));
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        return builder.toString();
    }

    protected String printColumnNames() {
        StringBuilder builder = new StringBuilder();
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        int column = 0;
        while (column < this.tableModel.getColumnCount()) {
            if (column > 0) {
                builder.append(this.getColumnSeparatorChar());
            }
            String columnName = StringUtils.capitalize(this.tableModel.getColumnName(column));
            int columWidth = this.minWidths[column];
            builder.append(this.printColumnName(columnName, columWidth));
            ++column;
        }
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        return builder.toString();
    }

    protected String printColumnName(String columnName, int columWidth) {
        String colName = StringUtils.abbreviate(this.addPadding(columnName), columWidth);
        return ASCIITable.printText(this.columnNameJustification, columWidth, colName);
    }

    protected String printHorizontalBorder() {
        StringBuilder builder = new StringBuilder();
        if (this.isBordered()) {
            builder.append('+');
        }
        int column = 0;
        while (column < this.minWidths.length) {
            if (column > 0) {
                builder.append('+');
            }
            builder.append(StringUtils.repeat(String.valueOf(this.getRowSeparatorChar()), this.minWidths[column]));
            ++column;
        }
        if (this.isBordered()) {
            builder.append('+');
        }
        return builder.toString();
    }

    protected void printValues(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        int rowCount = this.tableModel.getRowCount();
        int row = 0;
        while (row < rowCount) {
            builder.setLength(0);
            if (this.isBordered()) {
                builder.append(this.getColumnSeparatorChar());
            }
            int column = 0;
            while (column < this.tableModel.getColumnCount()) {
                if (column > 0) {
                    builder.append(this.getColumnSeparatorChar());
                }
                builder.append(this.printValue(row, column));
                ++column;
            }
            if (this.isBordered()) {
                builder.append(this.getColumnSeparatorChar());
            }
            lines.add(builder.toString());
            ++row;
        }
    }

    protected String printValue(int row, int column) {
        Class<?> clazz = this.tableModel.getColumnClass(column);
        String renderedValue = this.addPadding(this.getRenderedValue(row, column));
        int columnWidth = this.minWidths[column];
        if (Number.class.isAssignableFrom(clazz)) {
            return StringUtils.leftPad(StringUtils.abbreviate(renderedValue, columnWidth), columnWidth);
        }
        return StringUtils.rightPad(StringUtils.abbreviate(renderedValue, columnWidth), columnWidth);
    }

    private final String getRenderedValue(int row, int column) {
        Class<?> clazz = this.tableModel.getColumnClass(column);
        Object value = this.tableModel.getValueAt(row, column);
        return TableRenderer.render(clazz, value);
    }

    protected String printTotal() {
        StringBuilder builder = new StringBuilder();
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        String total = "(" + this.tableModel.getRowCount() + " rows)";
        builder.append(StringUtils.rightPad(total, this.getTableWidth()));
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        return builder.toString();
    }

    protected String printComment() {
        StringBuilder builder = new StringBuilder();
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        builder.append(StringUtils.rightPad(this.tableComment, this.getTableWidth()));
        if (this.isBordered()) {
            builder.append(this.getColumnSeparatorChar());
        }
        return builder.toString();
    }

    public final int getColumnWidth(int column) {
        assert (this.minWidths != null);
        assert (column > -1 && column < this.minWidths.length);
        return this.minWidths[column];
    }

    public final void setColumnWidth(int column, int width) {
        assert (this.minWidths != null);
        assert (column > -1 && column < this.minWidths.length);
        assert (width > 3);
        this.minWidths[column] = width;
    }

    public final void setColumnNameJustification(Justification columnNameJustification) {
        this.columnNameJustification = columnNameJustification;
    }

    public final void setHeaderJustification(Justification headerJustification) {
        this.headerJustification = headerJustification;
    }

    public final List<String> printTable() {
        ArrayList<String> lines = new ArrayList<String>();
        String header = this.tableModel.getHeader();
        if (this.tableModel.getRowCount() == 0 && this.tableModel.getColumnCount() == 0) {
            lines.add(header);
        } else {
            this.printTitles(lines, header);
        }
        this.printValues(lines);
        lines.add(this.printTotal());
        if (StringUtils.isNotEmpty(this.tableComment)) {
            lines.add(this.printComment());
        }
        if (this.isBordered()) {
            lines.add(this.printHorizontalBorder());
        }
        return lines;
    }

    private void printTitles(List<String> lines, String header) {
        if (this.isBordered()) {
            lines.add(this.printHorizontalBorder());
        }
        if (StringUtils.isNotEmpty(header)) {
            lines.add(this.printHeader());
        }
        lines.add(this.printColumnNames());
        lines.add(this.printHorizontalBorder());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Justification {
        CENTER,
        LEFT,
        RIGHT;

    }
}

