/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.FileFormatType;
import ch.systemsx.cisd.lims.base.FileProperty;
import ch.systemsx.cisd.lims.base.LocatorType;
import ch.systemsx.cisd.lims.base.MoleculeCriteria;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.base.ObservableType;
import ch.systemsx.cisd.lims.base.PlateDimension;
import ch.systemsx.cisd.lims.base.ProcedureTypeCode;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.WellCoordinates;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.server.business.plateutil.PlateWellCoordsParser;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public final class ParameterChecker {
    private static final String[] INVALID_PROPERTY_TYPE_CODES = new String[]{"code"};

    private ParameterChecker() {
    }

    public static final void checkIfNotNull(Object object, String name) throws UserFailureException {
        if (object == null) {
            throw UserFailureException.fromTemplate("No %s specified.", name);
        }
    }

    public static void checkIfNotBlank(String object, String name) throws UserFailureException {
        if (StringUtils.isBlank(object)) {
            throw UserFailureException.fromTemplate("No %s specified.", name);
        }
    }

    public static final void checkExperimentIdentifier(ExperimentIdentifier experimentIdentifier) throws UserFailureException {
        ParameterChecker.checkIfNotNull(experimentIdentifier, "experiment identifier");
        ParameterChecker.checkIfNotNull(experimentIdentifier.getProjectCode(), "project code");
        ParameterChecker.checkIfNotNull(experimentIdentifier.getExperimentCode(), "experiment code");
    }

    public static final void checkExternalData(ExternalData externalData) {
        ParameterChecker.checkIfNotNull(externalData, "external data");
        ParameterChecker.checkIfNotNull(externalData.getLocation(), "location");
        ParameterChecker.checkLocatorType(externalData.getLocatorType());
        ParameterChecker.checkObservableType(externalData.getObservableType());
        ParameterChecker.checkFileFormatType(externalData.getFileFormatType());
    }

    public static final void checkFileFormatType(FileFormatType fileFormatType) {
        ParameterChecker.checkIfNotNull(fileFormatType, "file format type");
        ParameterChecker.checkIfNotNull(fileFormatType.getCode(), "file format type code");
    }

    public static final void checkObservableType(ObservableType observableType) {
        ParameterChecker.checkIfNotNull(observableType, "observable type");
        ParameterChecker.checkIfNotNull(observableType.getCode(), "observable type code");
    }

    public static final void checkLocatorType(LocatorType locatorType) {
        ParameterChecker.checkIfNotNull(locatorType, "location type");
        ParameterChecker.checkIfNotNull(locatorType.getCode(), "location type code");
    }

    public static final void checkExperimentFileProperty(ExperimentFileAttachment experimentFileProperty) {
        ParameterChecker.checkIfNotNull(experimentFileProperty, "experiment file property");
        ParameterChecker.checkIfNotNull(experimentFileProperty.getValue(), "experiment file content");
        ParameterChecker.checkExperimentFile(experimentFileProperty.getFileProperty());
    }

    public static final void checkExperimentFile(FileProperty fileProperty) {
        ParameterChecker.checkIfNotNull(fileProperty, "file property");
        ParameterChecker.checkIfNotNull(fileProperty.getFileName(), "file name");
    }

    public static final void checkMoleculeCriteria(MoleculeCriteria moleculeCriteria) {
        ParameterChecker.checkIfNotNull(moleculeCriteria, "molecule criteria");
        if ((moleculeCriteria.getCode() == null || moleculeCriteria.getTypeCode() == null) && moleculeCriteria.getGeneSymbol() == null) {
            throw UserFailureException.fromTemplate("Either the code and type code or the gene symbol must be specified.", new Object[0]);
        }
    }

    public static final void checkSampleComponents(NewSampleComponent[] sampleComponents, PlateDimension plateDimension) {
        ParameterChecker.checkIfNotNull(sampleComponents, "sample components");
        HashSet<WellCoordinates> set = new HashSet<WellCoordinates>();
        int i = 0;
        while (i < sampleComponents.length) {
            NewSampleComponent component = sampleComponents[i];
            ParameterChecker.checkIfNotNull(component, "sample component");
            String codeFromUser = component.getCode();
            WellCoordinates wellCoords = PlateWellCoordsParser.tryParseCoords(codeFromUser);
            if (wellCoords == null) {
                throw UserFailureException.fromTemplate("Wrong well code format '%s'.", codeFromUser);
            }
            if (wellCoords.getColumnIndex() >= plateDimension.getColsNum() || wellCoords.getRowIndex() >= plateDimension.getRowsNum()) {
                throw UserFailureException.fromTemplate("Well '%s' is outside of the plate.", codeFromUser);
            }
            if (!set.add(wellCoords)) {
                throw UserFailureException.fromTemplate("Wrong data. Well code '%s' occurs more than once.", codeFromUser);
            }
            ++i;
        }
    }

    public static final void checkProcedureTypeCode(String procedureTypeCode) throws UserFailureException {
        ParameterChecker.checkIfNotNull(procedureTypeCode, "procedure type code");
        try {
            ProcedureTypeCode.getProcedureTypeCode(procedureTypeCode);
        }
        catch (IllegalArgumentException ex) {
            throw new UserFailureException(ex.getMessage());
        }
    }

    public static final void checkPropertyType(PropertyType[] properties) throws UserFailureException {
        ParameterChecker.checkIfNotNull(properties, "properties");
        String[] stringArray = INVALID_PROPERTY_TYPE_CODES;
        int n = INVALID_PROPERTY_TYPE_CODES.length;
        int n2 = 0;
        while (n2 < n) {
            String invalidCode = stringArray[n2];
            PropertyType[] propertyTypeArray = properties;
            int n3 = properties.length;
            int n4 = 0;
            while (n4 < n3) {
                PropertyType propertyType = propertyTypeArray[n4];
                if (propertyType.getCode().equalsIgnoreCase(invalidCode)) {
                    throw UserFailureException.fromTemplate("Property type code %s is invalid.", invalidCode);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static final void checkQueryRestriction(QueryRestriction queryRestriction) {
        ParameterChecker.checkIfNotNull(queryRestriction, "query restriction");
    }
}

