/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.server.business.bo.AbstractPropertyValueProvider;
import ch.systemsx.cisd.lims.server.business.bo.IKey;
import ch.systemsx.cisd.lims.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.lims.server.dto.ICodeAndIDHolder;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CodeBasedPropertyValueProvider
extends AbstractPropertyValueProvider {
    CodeBasedPropertyValueProvider(PropertyTypeDTO propertyType, IVocabularyDAO vocabularyDAO, String untypedDefaultValueOrNull, EntityPropertyFiller[] fillers) {
        super(propertyType, vocabularyDAO, untypedDefaultValueOrNull);
        this.setEntityPropertyFillers(fillers);
    }

    @Override
    protected final IKeyExtractor<IKey, EntityPropertyFiller> createKeyExtractor() {
        return new IKeyExtractor<IKey, EntityPropertyFiller>(){

            @Override
            public final IKey getKey(EntityPropertyFiller v) {
                return new CodeKey(v.getEntityCode());
            }
        };
    }

    @Override
    protected final IKey tryTranslate(ICodeAndIDHolder codeAndIDHolder) {
        return new CodeKey(codeAndIDHolder.getCode());
    }

    @Override
    public final IKey getKey(ICodeAndIDHolder codeAndIDHolder) {
        return this.tryTranslate(codeAndIDHolder);
    }

    private static final class CodeKey
    extends AbstractHashable
    implements IKey {
        private final String code;

        CodeKey(String code) {
            assert (code != null);
            this.code = code;
        }

        public final String getUniqueDescription() {
            return this.code;
        }
    }
}

