/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.ExperimentPropertyFiller;
import ch.systemsx.cisd.lims.server.business.bo.AbstractPropertyValueProvider;
import ch.systemsx.cisd.lims.server.business.bo.IKey;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ICodeAndIDHolder;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExperimentPropertyValueProvider
extends AbstractPropertyValueProvider {
    private final long groupId;
    private final TableMap<Long, BaseExperimentDTO> experimentsByID;

    public ExperimentPropertyValueProvider(PropertyTypeDTO propertyType, IDAOFactory daoFactory, String untypedDefaultValueOrNull, EntityPropertyFiller[] fillers, long groupId) {
        super(propertyType, daoFactory.getVocabularyDAO(), untypedDefaultValueOrNull);
        this.groupId = groupId;
        List<BaseExperimentDTO> baseExperiments = daoFactory.getExperimentDAO().listBaseExperiments(false);
        this.enrichWithProject(daoFactory.getProjectDAO(), baseExperiments);
        this.experimentsByID = new TableMap<Long, BaseExperimentDTO>(baseExperiments, KeyExtractorFactory.getBaseExperimentByIdKeyExtractor());
        this.setEntityPropertyFillers(fillers);
    }

    private final void enrichWithProject(IProjectDAO projectDAO, List<BaseExperimentDTO> experiments) {
        List<ProjectDTO> projects = projectDAO.listProjects(null);
        TableMap<Long, ProjectDTO> projectsByID = new TableMap<Long, ProjectDTO>(projects, KeyExtractorFactory.getProjectByIdKeyExtractor());
        for (BaseExperimentDTO experiment : experiments) {
            Long projectID = experiment.getProjectID();
            assert (projectID != null) : String.format("No project id specified for experiment code '%s'.", experiment.getCode());
            ProjectDTO project = projectsByID.tryGet(projectID);
            assert (project != null) : String.format("No project found for id '%d'.", projectID);
            experiment.setProject(project);
        }
    }

    @Override
    protected final IKeyExtractor<IKey, EntityPropertyFiller> createKeyExtractor() {
        return new IKeyExtractor<IKey, EntityPropertyFiller>(){

            @Override
            public final IKey getKey(EntityPropertyFiller entityPropertyFiller) {
                if (!(entityPropertyFiller instanceof ExperimentPropertyFiller)) {
                    throw new IllegalArgumentException("Not of type " + ExperimentPropertyFiller.class.getName() + ": " + entityPropertyFiller.getClass());
                }
                ExperimentPropertyFiller propertyFiller = (ExperimentPropertyFiller)entityPropertyFiller;
                return new ExperimentKey(propertyFiller.getEntityCode(), propertyFiller.getProjectCode(), ExperimentPropertyValueProvider.this.groupId);
            }
        };
    }

    @Override
    protected final IKey tryTranslate(ICodeAndIDHolder codeAndIDHolder) {
        BaseExperimentDTO experiment = this.experimentsByID.tryGet(codeAndIDHolder.getId());
        assert (experiment != null) : "Experiment can not be null.";
        ProjectDTO project = experiment.getProject();
        assert (project != null) : "Unspecified project.";
        if (!project.getGroupId().equals(this.groupId)) {
            return null;
        }
        return new ExperimentKey(experiment.getCode(), project.getCode(), project.getGroupId());
    }

    @Override
    public final IKey getKey(ICodeAndIDHolder codeAndIDHolder) {
        BaseExperimentDTO experiment = this.experimentsByID.tryGet(codeAndIDHolder.getId());
        return new ExperimentKeyWithCode(experiment);
    }

    private static class ExperimentKey
    extends AbstractHashable
    implements IKey {
        private final String experimentCode;
        private final String projectCode;
        private final long groupId;

        ExperimentKey(String experimentCode, String projectCode, long groupId) {
            this.experimentCode = experimentCode;
            this.projectCode = projectCode;
            this.groupId = groupId;
        }

        public final String getExperimentCode() {
            return this.experimentCode;
        }

        public final String getProjectCode() {
            return this.projectCode;
        }

        public final long getGroupId() {
            return this.groupId;
        }

        public final String getUniqueDescription() {
            return String.valueOf(this.experimentCode) + " [" + this.projectCode + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExperimentKeyWithCode
    implements IKey,
    Comparable<ExperimentKeyWithCode> {
        private final BaseExperimentDTO experiment;

        ExperimentKeyWithCode(BaseExperimentDTO experiment) {
            this.experiment = experiment;
        }

        @Override
        public final String getUniqueDescription() {
            ProjectDTO project = this.experiment.getProject();
            String groupCode = project.getGroup().getCode();
            return String.valueOf(groupCode) + ": " + this.experiment.getCode() + " [" + project.getCode() + "]";
        }

        @Override
        public final int compareTo(ExperimentKeyWithCode o) {
            return this.getUniqueDescription().compareTo(o.getUniqueDescription());
        }
    }
}

