/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.server.dataaccess.IInvalidationDAO;
import ch.systemsx.cisd.lims.server.dto.IInvalidationHolder;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvalidationFiller {
    private InvalidationFiller() {
    }

    static final void fillInvalidationFor(Iterable<? extends IInvalidationHolder> iterable, IInvalidationDAO invalidationDAO) {
        assert (iterable != null) : "Given iterable can not be null.";
        assert (invalidationDAO != null) : "Given IInvalidationDAO can not be null.";
        List<InvalidationDTO> invalidations = invalidationDAO.listInvalidations();
        if (invalidations.size() == 0) {
            return;
        }
        TableMap<Long, InvalidationDTO> table = new TableMap<Long, InvalidationDTO>(invalidations, new IKeyExtractor<Long, InvalidationDTO>(){

            @Override
            public final Long getKey(InvalidationDTO e) {
                return e.getId();
            }
        });
        for (IInvalidationHolder iInvalidationHolder : iterable) {
            Long invalidationId;
            InvalidationDTO invalidation = iInvalidationHolder.getInvalidation();
            if (invalidation != null || (invalidationId = iInvalidationHolder.getInvalidationId()) == null) continue;
            InvalidationDTO invalidationDTO = table.tryGet(invalidationId);
            assert (invalidationDTO != null) : "Invalidation data can not be null.";
            iInvalidationHolder.setInvalidation(invalidationDTO);
        }
    }

    static final void enrichParentAndTopWithInvalidation(IInvalidationDAO invalidationDAO, SampleDTO ... samples) {
        ArrayList<SampleDTO> collection = new ArrayList<SampleDTO>();
        SampleDTO[] sampleDTOArray = samples;
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            SampleDTO sample = sampleDTOArray[n2];
            InvalidationFiller.addToCollection(collection, sample.getGeneratedFrom());
            InvalidationFiller.addToCollection(collection, sample.getTop());
            ++n2;
        }
        InvalidationFiller.fillInvalidationFor(collection, invalidationDAO);
    }

    private static final void addToCollection(Collection<SampleDTO> collection, SampleDTO sample) {
        if (sample != null && sample.getInvalidationId() != null) {
            collection.add(sample);
        }
    }
}

