/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.EntityType;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.MoleculeCriteria;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.business.bo.IMaterialTable;
import ch.systemsx.cisd.lims.server.business.bo.RegistratorFiller;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MaterialTable
extends AbstractBusinessObject
implements IMaterialTable {
    private final List<MaterialDTO> addedMaterials = new ArrayList<MaterialDTO>();
    private final List<String> alreadyRegisteredMaterials = new ArrayList<String>();
    private final List<String> moleculesWithNonExistingInhibitorOf = new ArrayList<String>();
    private final Map<String, MaterialsByCode> materialsByTypeAndCode = new HashMap<String, MaterialsByCode>();
    private final MaterialTypesByCode materialTypes = new MaterialTypesByCode(this.getEntityTypeDAO(EntityKind.MATERIAL).listEntityTypes());
    private MaterialsByCode materials;
    private final IEntityPropertiesConverter entityPropertiesConverter;

    public MaterialTable(IDAOFactory daoFactory, IEntityPropertiesConverter entityPropertiesConverter, Session session) {
        super(daoFactory, session);
        this.entityPropertiesConverter = entityPropertiesConverter;
    }

    private EntityTypeDTO tryFindMaterialTypeDTO(String typeCode) {
        return (EntityTypeDTO)this.materialTypes.tryGet(typeCode);
    }

    static final long getMaterialId(IMaterialDAO materialDAO, String materialCode, String materialTypeCode) throws UserFailureException {
        Long materialID = materialDAO.tryFindMaterialIdByCodeAndTypeCode(materialCode, materialTypeCode);
        if (materialID == null) {
            throw UserFailureException.fromTemplate("No material with code '%s' and type code '%s' could be found in the database.", materialCode, materialTypeCode);
        }
        return materialID;
    }

    @Override
    public final void loadByMaterialType(String materialTypeCode) {
        this.materials = this.getMaterialsByCodeForType(materialTypeCode);
    }

    @Override
    public final void loadByMoleculeCriteria(MoleculeCriteria criteria) {
        this.materials = new MaterialsByCode(new ArrayList<MaterialDTO>());
        IMaterialDAO materialDAO = this.getMaterialDAO();
        String materialCode = criteria.getCode();
        String materialTypeCode = criteria.getTypeCode();
        if (materialCode != null) {
            Long materialID = MaterialTable.getMaterialId(materialDAO, materialCode, materialTypeCode);
            this.materials.add(materialDAO.getMaterialById(materialID));
        } else {
            String geneSymbol = criteria.getGeneSymbol();
            List<MaterialDTO> molecules = materialDAO.listMoleculesForGeneSymbol(geneSymbol);
            if (molecules.size() == 0) {
                throw UserFailureException.fromTemplate("No molecule could be found for gene symbol '%s'.", geneSymbol);
            }
            for (MaterialDTO materialDTO : molecules) {
                this.materials.add(materialDTO);
            }
        }
    }

    @Override
    public final void add(Material material) {
        assert (material != null) : "Unspecified material.";
        EntityType materialType = material.getMaterialType();
        assert (materialType != null) : "Unspecified material type.";
        String materialTypeCode = materialType.getCode();
        assert (materialTypeCode != null) : "Unspecified material type code.";
        String code = material.getCode();
        assert (code != null) : "Unspecified material code.";
        MaterialsByCode materialsByCode = this.getMaterialsByCodeForType(materialTypeCode);
        if (materialsByCode.tryGet(code) != null) {
            this.alreadyRegisteredMaterials.add(code);
        } else {
            final Long registratorID = this.findRegistratorID();
            MaterialDTO materialDTO = new MaterialDTO(registratorID);
            final MaterialDTO inhibitor = this.tryToFindInhibitedBy(material);
            BeanUtils.fillBean(MaterialDTO.class, materialDTO, material, new BeanUtils.Converter(){

                public final MaterialDTO convertToInhibitorOf(Material inhibitorOf) {
                    return inhibitor;
                }

                public EntityPropertyValueDTO[] convertToProperties(Material material2) {
                    SimpleEntityProperty[] properties = material2.getProperties();
                    String typeCode = material2.getEntityType().getCode();
                    return MaterialTable.this.entityPropertiesConverter.convertProperties(properties, typeCode, registratorID);
                }
            });
            EntityTypeDTO materialTypeDTO = this.tryFindMaterialTypeDTO(material.getMaterialType().getCode());
            materialDTO.setMaterialType(materialTypeDTO);
            this.addedMaterials.add(materialDTO);
            materialsByCode.add(materialDTO);
        }
    }

    private MaterialDTO tryToFindInhibitedBy(Material material) {
        Material inhibited = material.getInhibitorOf();
        if (inhibited == null) {
            return null;
        }
        String materialCode = material.getCode();
        assert (materialCode != null) : "Unspecified material code.";
        EntityType typeOfInhibited = inhibited.getMaterialType();
        assert (typeOfInhibited != null) : "Unspecified type of material inhibited by " + materialCode;
        String typeCodeOfInhibited = typeOfInhibited.getCode();
        assert (typeCodeOfInhibited != null) : "Unspecified type code of material inhibited by " + materialCode;
        String code = inhibited.getCode();
        MaterialDTO result = (MaterialDTO)this.getMaterialsByCodeForType(typeCodeOfInhibited).tryGet(code);
        if (result == null) {
            this.moleculesWithNonExistingInhibitorOf.add(materialCode);
        }
        return result;
    }

    private MaterialsByCode getMaterialsByCodeForType(String materialTypeCode) {
        MaterialsByCode materialsByCode = this.materialsByTypeAndCode.get(materialTypeCode);
        if (materialsByCode == null) {
            EntityTypeDTO materialType = this.tryFindMaterialTypeDTO(materialTypeCode);
            if (materialType == null) {
                throw new UserFailureException("Invalid material type code: " + materialTypeCode);
            }
            materialsByCode = new MaterialsByCode(this.getMaterialDAO().listMaterials(materialTypeCode));
            this.materialsByTypeAndCode.put(materialTypeCode, materialsByCode);
        }
        return materialsByCode;
    }

    @Override
    public MaterialDTO tryToFindByTypeAndCode(String typeCode, String code) {
        MaterialsByCode materialsByCode = this.materialsByTypeAndCode.get(typeCode);
        return materialsByCode == null ? null : (MaterialDTO)materialsByCode.tryGet(code);
    }

    @Override
    public void enrichWithRegistrator() {
        RegistratorFiller.fillRegistratorsFor(this.materials, this.getPersonDAO());
    }

    @Override
    public List<MaterialDTO> getMaterials() {
        ArrayList<MaterialDTO> list = new ArrayList<MaterialDTO>();
        for (MaterialDTO materialDTO : this.materials) {
            list.add(materialDTO);
        }
        return list;
    }

    @Override
    public final MaterialDTO tryToFindByCode(String code) {
        return (MaterialDTO)this.materials.tryGet(code);
    }

    @Override
    public final Set<MaterialDTO> findInhibitors() {
        LinkedHashSet<MaterialDTO> inhibitors = new LinkedHashSet<MaterialDTO>();
        IMaterialDAO materialDAO = this.getMaterialDAO();
        for (MaterialDTO material : this.materials) {
            inhibitors.addAll(materialDAO.findInhibitorsForId(material.getId()));
        }
        return inhibitors;
    }

    @Override
    public final List<String> getAlreadyRegisteredMaterials() {
        return Collections.unmodifiableList(this.alreadyRegisteredMaterials);
    }

    @Override
    public final List<String> getMaterialsWithNonExistingInhibitorOf() {
        return Collections.unmodifiableList(this.moleculesWithNonExistingInhibitorOf);
    }

    @Override
    public final Iterator<MaterialDTO> iterator() {
        return this.materials.iterator();
    }

    @Override
    public final void save() {
        IMaterialDAO materialDAO = this.getMaterialDAO();
        IEntityPropertyTypeDAO entityPropertyTypeDAO = this.getEntityPropertyTypeDAO(EntityKind.MATERIAL);
        for (MaterialDTO material : this.addedMaterials) {
            try {
                materialDAO.createMaterial(material);
                entityPropertyTypeDAO.createProperties(material);
            }
            catch (DataAccessException ex) {
                MaterialTable.throwException(ex, String.format("Material '%s'", material.getCode()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaterialTypesByCode
    extends TableMap<String, EntityTypeDTO> {
        MaterialTypesByCode(Collection<EntityTypeDTO> rows) {
            super(rows, new IKeyExtractor<String, EntityTypeDTO>(){

                @Override
                public String getKey(EntityTypeDTO e) {
                    return e.getCode();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaterialsByCode
    extends TableMap<String, MaterialDTO> {
        MaterialsByCode(Collection<MaterialDTO> rows) {
            super(rows, new IKeyExtractor<String, MaterialDTO>(){

                @Override
                public String getKey(MaterialDTO e) {
                    return e.getCode();
                }
            });
        }
    }
}

