/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractProcedureBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureTable;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcedureTable
extends AbstractProcedureBusinessObject
implements IProcedureTable {
    private List<ProcedureDTO> procedures;

    public ProcedureTable(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    @Override
    public final void loadByExperimentID(long experimentID) {
        this.procedures = this.getProcedureDAO().listProcedures(experimentID);
    }

    @Override
    public void enrichWithScreenablePlates() {
        for (ProcedureDTO procedure : this.procedures) {
            this.enrichWithScreenableSamples(procedure);
        }
    }

    @Override
    public final void enrichWithScreenablePlatesAndData() {
        for (ProcedureDTO procedure : this.procedures) {
            this.enrichWithSamplesAndData(procedure);
        }
    }

    @Override
    public void enrichWithControlLayout() {
        for (ProcedureDTO procedure : this.procedures) {
            this.enrichWithControlLayout(procedure);
        }
    }

    @Override
    public final void save() {
        throw new UnsupportedOperationException("Procedure table can not be saved.");
    }

    @Override
    public final Iterator<ProcedureDTO> iterator() {
        return this.procedures.iterator();
    }
}

