/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.lims.server.dataaccess.db.DBRestrictionChecker;
import ch.systemsx.cisd.lims.server.dataaccess.db.IDtoValidator;
import ch.systemsx.cisd.lims.server.dto.DataDTO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentFileAttachmentDTO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialBatchDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyTermDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.dao.DataIntegrityViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DtoValidatorStore {
    private static final Pattern CODE_PATTERN = Pattern.compile("^[A-Z0-9_\\-]+$", 2);
    private static final Pattern CODE_PATTERN_USER_NAMESPACE = Pattern.compile("^USER\\.[A-Z0-9_\\-]+$", 2);
    private final DBRestrictionChecker restrictionChecker;
    private final Map<Class<?>, IDtoValidator<?>> dtoValidators;

    DtoValidatorStore(DBRestrictionChecker restrictionChecker) {
        assert (restrictionChecker != null) : "restrictionChecker can not be null.";
        this.restrictionChecker = restrictionChecker;
        this.dtoValidators = new HashMap();
        this.registerDefaultDTOValidators();
    }

    static final void checkCode(String code, boolean userNamespace) throws DataIntegrityViolationException {
        if (!DtoValidatorStore.isCodeOK(code, userNamespace)) {
            throw new DataIntegrityViolationException(DtoValidatorStore.createErrorMessageForIllegalCode(code, userNamespace));
        }
    }

    private static final boolean isCodeOK(String code, boolean userNamespace) {
        if (userNamespace) {
            return CODE_PATTERN_USER_NAMESPACE.matcher(code).matches();
        }
        return CODE_PATTERN.matcher(code).matches();
    }

    private static final String createErrorMessageForIllegalCode(String illegalCode, boolean userNamespace) {
        String illegalUpperCaseCode = illegalCode.toUpperCase();
        if (userNamespace && !illegalUpperCaseCode.startsWith("USER.")) {
            return "Code '" + illegalUpperCaseCode + "' does not start with '" + "USER." + "'";
        }
        if (!userNamespace && illegalUpperCaseCode.startsWith("USER.")) {
            return "Code '" + illegalUpperCaseCode + "' starts with illegal prefix '" + "USER." + "'";
        }
        if (illegalUpperCaseCode.length() < 1) {
            return "Code '" + illegalUpperCaseCode + "' is too short (minimal length: 1 character)";
        }
        return "Code '" + illegalUpperCaseCode + "' contains illegal characters (allowed: A-Z, a-z, 0-9, _ and -)";
    }

    private final void registerDefaultDTOValidators() {
        this.registerDTOValidator(ExperimentDTO.class, new ExperimentValidator());
        this.registerDTOValidator(ExperimentFileAttachmentDTO.class, new ExperimentFileAttachmentValidator());
        this.registerDTOValidator(PersonDTO.class, new PersonValidator());
        this.registerDTOValidator(MaterialDTO.class, new MaterialValidator());
        this.registerDTOValidator(SampleDTO.class, new SampleValidator());
        this.registerDTOValidator(DataDTO.class, new DataValidator());
        this.registerDTOValidator(ExternalDataDTO.class, new ExternalDataValidator());
        this.registerDTOValidator(ProjectDTO.class, new ProjectValidator());
        this.registerDTOValidator(PropertyTypeDTO.class, new PropertyTypeValidator());
        this.registerDTOValidator(InvalidationDTO.class, new InvalidationValidator());
        this.registerDTOValidator(VocabularyDTO.class, new VocabularyValidator());
        this.registerDTOValidator(VocabularyTermDTO.class, new VocabularyTermValidator());
        this.registerDTOValidator(MaterialBatchDTO.class, new MaterialBatchValidator());
        this.registerDTOValidator(GroupDTO.class, new GroupValidator());
    }

    private final <T> void registerDTOValidator(Class<T> clazz, IDtoValidator<T> validator) {
        assert (this.dtoValidators.get(clazz) == null) : String.format("Validator already registered for class '%s'.", clazz.getName());
        this.dtoValidators.put(clazz, validator);
    }

    public final <E> IDtoValidator<E> getDTOValidator(E dto) {
        assert (dto != null) : "Given DTO can not be null.";
        return this.getDTOValidatorForClass(dto.getClass());
    }

    private final <E> IDtoValidator<E> getDTOValidatorForClass(Class<? extends E> clazz) {
        IDtoValidator<?> validator = this.dtoValidators.get(clazz);
        Class<? extends E> superclass = clazz.getSuperclass();
        if (validator == null && superclass != null) {
            return this.getDTOValidatorForClass(superclass);
        }
        return validator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DataValidator
    implements IDtoValidator<DataDTO> {
        private DataValidator() {
        }

        @Override
        public final void validate(DataDTO data) throws DataIntegrityViolationException {
            assert (data != null) : "Given DatatDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("data", "code", data.getCode());
            DtoValidatorStore.checkCode(data.getCode(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExperimentFileAttachmentValidator
    implements IDtoValidator<ExperimentFileAttachmentDTO> {
        private ExperimentFileAttachmentValidator() {
        }

        @Override
        public final void validate(ExperimentFileAttachmentDTO fileProperty) throws DataIntegrityViolationException {
            assert (fileProperty != null) : "Given ExperimentFilePropertyDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("experiment_attachments", "file_name", fileProperty.getFileProperty().getFileName());
            DtoValidatorStore.this.restrictionChecker.check("experiment_attachments", "value", fileProperty.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExperimentValidator
    implements IDtoValidator<ExperimentDTO> {
        private ExperimentValidator() {
        }

        @Override
        public final void validate(ExperimentDTO experiment) throws DataIntegrityViolationException {
            assert (experiment != null) : "Given ExperimentDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("experiments", "code", experiment.getCode());
            DtoValidatorStore.checkCode(experiment.getCode(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExternalDataValidator
    implements IDtoValidator<ExternalDataDTO> {
        private final DataValidator parentValidator;

        private ExternalDataValidator() {
            this.parentValidator = new DataValidator();
        }

        @Override
        public final void validate(ExternalDataDTO externalData) throws DataIntegrityViolationException {
            assert (externalData != null) : "Given ExternalDataDTO can not be null.";
            this.parentValidator.validate(externalData);
            DtoValidatorStore.this.restrictionChecker.check("external_data", "location", externalData.getLocation());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GroupValidator
    implements IDtoValidator<GroupDTO> {
        private GroupValidator() {
        }

        @Override
        public void validate(GroupDTO group) throws DataIntegrityViolationException {
            assert (group != null) : "Given group cannot be null.";
            DtoValidatorStore.this.restrictionChecker.check("groups", "code", group.getCode());
            DtoValidatorStore.checkCode(group.getCode(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationValidator
    implements IDtoValidator<InvalidationDTO> {
        private InvalidationValidator() {
        }

        @Override
        public final void validate(InvalidationDTO invalidationDTO) throws DataIntegrityViolationException {
            assert (invalidationDTO != null) : "Given InvalidationDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("invalidations", "reason", invalidationDTO.getReason());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MaterialBatchValidator
    implements IDtoValidator<MaterialBatchDTO> {
        private MaterialBatchValidator() {
        }

        @Override
        public final void validate(MaterialBatchDTO dto) throws DataIntegrityViolationException {
            assert (dto != null) : "Given MaterialBatchDTO can not be null.";
            String code = dto.getCode();
            DtoValidatorStore.this.restrictionChecker.check("material_batches", "code", code);
            DtoValidatorStore.checkCode(code, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MaterialValidator
    implements IDtoValidator<MaterialDTO> {
        private MaterialValidator() {
        }

        @Override
        public final void validate(MaterialDTO material) throws DataIntegrityViolationException {
            EntityPropertyValueDTO[] properties;
            assert (material != null) : "Given MaterialDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("materials", "code", material.getCode());
            DtoValidatorStore.checkCode(material.getCode(), false);
            EntityPropertyValueDTO[] entityPropertyValueDTOArray = properties = material.getProperties();
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                EntityPropertyValueDTO property = entityPropertyValueDTOArray[n2];
                String propertyValue = property.tryGetUntypedValue();
                if (propertyValue != null) {
                    DtoValidatorStore.this.restrictionChecker.check("material_properties", "value", propertyValue);
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PersonValidator
    implements IDtoValidator<PersonDTO> {
        private PersonValidator() {
        }

        @Override
        public final void validate(PersonDTO person) throws DataIntegrityViolationException {
            assert (person != null) : "Given PersonDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("persons", "user_id", person.getUserId());
            DtoValidatorStore.checkCode(person.getUserId(), false);
            DtoValidatorStore.this.restrictionChecker.check("persons", "first_name", person.getFirstName());
            DtoValidatorStore.this.restrictionChecker.check("persons", "last_name", person.getLastName());
            DtoValidatorStore.this.restrictionChecker.check("persons", "email", person.getEmail());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProjectValidator
    implements IDtoValidator<ProjectDTO> {
        private ProjectValidator() {
        }

        @Override
        public final void validate(ProjectDTO project) throws DataIntegrityViolationException {
            assert (project != null) : "Given ProjectDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("projects", "code", project.getCode());
            DtoValidatorStore.checkCode(project.getCode(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PropertyTypeValidator
    implements IDtoValidator<PropertyTypeDTO> {
        private PropertyTypeValidator() {
        }

        @Override
        public final void validate(PropertyTypeDTO propertyType) throws DataIntegrityViolationException {
            assert (propertyType != null) : "Given PropertyTypeDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("property_types", "code", propertyType.getCode());
            DtoValidatorStore.checkCode(propertyType.getCode(), true);
            DtoValidatorStore.this.restrictionChecker.check("property_types", "description", propertyType.getDescription());
            DtoValidatorStore.this.restrictionChecker.check("property_types", "label", propertyType.getUserLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SampleValidator
    implements IDtoValidator<SampleDTO> {
        private SampleValidator() {
        }

        @Override
        public final void validate(SampleDTO sample) throws DataIntegrityViolationException {
            assert (sample != null) : "Given SampleDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("samples", "code", sample.getCode());
            DtoValidatorStore.checkCode(sample.getCode(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VocabularyTermValidator
    implements IDtoValidator<VocabularyTermDTO> {
        private VocabularyTermValidator() {
        }

        @Override
        public final void validate(VocabularyTermDTO dto) throws DataIntegrityViolationException {
            assert (dto != null) : "Given VocabularyTermDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("controlled_vocabulary_terms", "code", dto.getCode());
            DtoValidatorStore.checkCode(dto.getCode(), false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VocabularyValidator
    implements IDtoValidator<VocabularyDTO> {
        private VocabularyValidator() {
        }

        @Override
        public final void validate(VocabularyDTO dto) throws DataIntegrityViolationException {
            assert (dto != null) : "Given VocabularyDTO can not be null.";
            DtoValidatorStore.this.restrictionChecker.check("controlled_vocabularies", "code", dto.getCode());
            DtoValidatorStore.checkCode(dto.getCode(), true);
            DtoValidatorStore.this.restrictionChecker.check("controlled_vocabularies", "description", dto.getDescription());
        }
    }
}

