/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallbackWithLoadingMask;
import ch.systemsx.cisd.lims.webclient.client.application.AbstractTreePanel;
import ch.systemsx.cisd.lims.webclient.client.application.BaseExperimentNode;
import ch.systemsx.cisd.lims.webclient.client.application.ProjectNode;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.utils.Log;
import ch.systemsx.cisd.lims.webclient.client.dto.BaseExperiment;
import ch.systemsx.cisd.lims.webclient.client.dto.Experiment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.client.dto.Project;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.event.TreePanelListener;
import com.gwtext.client.widgets.tree.event.TreePanelListenerAdapter;

class ExperimentExplorer
extends AbstractTreePanel {
    ExperimentExplorer(ViewContext viewContext) {
        super(viewContext);
        this.addTreePanelListener((TreePanelListener)new ExperimentExplorerTreePanelListener());
        this.setRootNode((Node)this.createRootNode());
        this.render();
        this.loadProjects();
    }

    private final void loadProjects() {
        this.viewContext.getLimService().listProjects(new ProjectAsyncCallback());
    }

    private final TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode(this.viewContext.getMessageResources().getExperimentExplorerTitle());
        return rootNode;
    }

    protected void displayExperiment(Experiment experiment) {
    }

    private final class BaseExperimentAsyncCallback
    extends AbstractAsyncCallback {
        private final ProjectNode projectNode;

        BaseExperimentAsyncCallback(ProjectNode projectNode) {
            super(ExperimentExplorer.this.viewContext);
            this.projectNode = projectNode;
        }

        public final void onSuccess(Object result) {
            BaseExperiment[] experiments = (BaseExperiment[])result;
            int i = 0;
            while (i < experiments.length) {
                BaseExperiment experiment = experiments[i];
                this.projectNode.appendChild((Node)new BaseExperimentNode(experiment));
                ++i;
            }
        }
    }

    private final class ExperimentAsyncCallback
    extends AbstractAsyncCallbackWithLoadingMask {
        private final long start;
        private final String experimentCode;

        ExperimentAsyncCallback(String experimentCode) {
            super(ExperimentExplorer.this.viewContext);
            this.start = System.currentTimeMillis();
            this.experimentCode = experimentCode;
        }

        protected final void afterSuccess(Object result) {
            Log.logTimeTaken(this.start, "Getting experiment '" + this.experimentCode + "'");
            ExperimentExplorer.this.displayExperiment((Experiment)result);
        }
    }

    private final class ExperimentExplorerTreePanelListener
    extends TreePanelListenerAdapter {
        private ExperimentExplorerTreePanelListener() {
        }

        private final ExperimentIdentifier createExperimentIdentifier(BaseExperiment baseExperiment) {
            ExperimentIdentifier identifier = new ExperimentIdentifier();
            identifier.setExperimentCode(baseExperiment.getCode());
            identifier.setProjectCode(baseExperiment.getProject().getCode());
            return identifier;
        }

        public final void onClick(TreeNode node, EventObject e) {
            Object userObject = node.getUserObject();
            if (userObject instanceof BaseExperiment) {
                Log.log("Experiment node '" + node.getText() + "' has been clicked.");
                BaseExperiment baseExperiment = (BaseExperiment)userObject;
                ExperimentExplorer.this.viewContext.getLimService().getExperimentInfo(this.createExperimentIdentifier(baseExperiment), new ExperimentAsyncCallback(baseExperiment.getCode()));
            }
        }
    }

    private final class ProjectAsyncCallback
    extends AbstractAsyncCallback {
        ProjectAsyncCallback() {
            super(ExperimentExplorer.this.viewContext);
        }

        public final void onSuccess(Object result) {
            Project[] projects = (Project[])result;
            int i = 0;
            while (i < projects.length) {
                Project project = projects[i];
                ProjectNode projectNode = new ProjectNode(project, ExperimentExplorer.this.viewContext.getMessageResources());
                ExperimentExplorer.this.getRootNode().appendChild((Node)projectNode);
                ExperimentExplorer.this.viewContext.getLimService().listExperiments(project.getCode(), new BaseExperimentAsyncCallback(projectNode));
                ++i;
            }
        }
    }
}

