/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.ColumnConfigs;
import ch.systemsx.cisd.lims.webclient.client.application.FilePropertyGrid;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.ui.AbstractLayoutDialog;
import ch.systemsx.cisd.lims.webclient.client.application.utils.PersonUtils;
import ch.systemsx.cisd.lims.webclient.client.application.utils.WindowUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.client.dto.FileProperty;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.Ext;
import com.gwtext.client.data.DateFieldDef;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.SimpleStore;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.Grid;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import com.gwtext.client.widgets.grid.event.GridCellListenerAdapter;
import java.util.ArrayList;
import java.util.List;

public class FilePropertyDialog
extends AbstractLayoutDialog {
    private static final String VERSION = "version";
    private final ExperimentIdentifier identifier;
    private final List fileProperties;
    private final String fileName;

    public FilePropertyDialog(String title, ExperimentIdentifier identifier, IMessageResources messageResources, List fileProperties) {
        super(messageResources, title);
        assert (identifier != null);
        this.identifier = identifier;
        this.fileProperties = fileProperties;
        this.fileName = FilePropertyDialog.getFileName(fileProperties);
        this.addContentPanel();
    }

    private static final String getFileName(List fileProperties) {
        assert (fileProperties != null && fileProperties.size() > 0);
        return ((FileProperty)fileProperties.get(0)).getFileName();
    }

    protected final Widget createContentWidget() {
        final Grid grid = new Grid(Ext.generateId(), null, null, FilePropertyDialog.createStore(this.identifier, this.fileProperties, this.messageResources), FilePropertyDialog.createColumnModel(this.messageResources), FilePropertyGrid.createGridConfig());
        grid.addGridCellListener((GridCellListener)new GridCellListenerAdapter(){

            public final void onCellClick(Grid g, int rowIndex, int colIndex, EventObject e) {
                String dataIndex = g.getColumnModel().getDataIndex(colIndex);
                if (dataIndex.equals(FilePropertyDialog.VERSION)) {
                    Record record = grid.getStore().getAt(rowIndex);
                    String url = FilePropertyGrid.createURL(record.getAsInteger(FilePropertyDialog.VERSION), FilePropertyDialog.this.fileName, FilePropertyDialog.this.identifier);
                    WindowUtils.openNewDependentWindow(url);
                }
            }
        });
        grid.render();
        return grid;
    }

    private static final ColumnModel createColumnModel(IMessageResources messageResources) {
        ColumnModel columnModel = new ColumnModel(FilePropertyDialog.createColumnConfigs(messageResources));
        return columnModel;
    }

    private static final ColumnConfig[] createColumnConfigs(IMessageResources messageResources) {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(ColumnConfigs.createRegistratorColumnConfig(messageResources));
        configs.add(ColumnConfigs.createRegistrationDateColumnConfig(messageResources));
        configs.add(FilePropertyDialog.createVersionColumnConfig(messageResources));
        return configs.toArray(new ColumnConfig[configs.size()]);
    }

    private static final ColumnConfig createVersionColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getFilePropertyVersionLabel());
        config.setSortable(true);
        config.setWidth(140);
        config.setDataIndex(VERSION);
        config.setRenderer(LinkRenderer.LINK_RENDERER);
        return config;
    }

    private static final Store createStore(ExperimentIdentifier identifier, List fileProperties, IMessageResources messageResources) {
        SimpleStore store = new SimpleStore(-1, FilePropertyDialog.createFieldDefs(), FilePropertyDialog.createData(identifier, fileProperties, messageResources));
        return store;
    }

    private static final FieldDef[] createFieldDefs() {
        ArrayList<Object> fieldDefs = new ArrayList<Object>();
        fieldDefs.add(new StringFieldDef("registrator"));
        fieldDefs.add(new DateFieldDef("registrationDate"));
        fieldDefs.add(new IntegerFieldDef(VERSION));
        return fieldDefs.toArray(new FieldDef[fieldDefs.size()]);
    }

    private static final Object[][] createData(ExperimentIdentifier identifier, List fileProperties, IMessageResources messageResources) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (FileProperty fileProperty : fileProperties) {
            String registrator = PersonUtils.toString(fileProperty.getRegistrator());
            Object[] objects = new Object[]{registrator, fileProperty.getRegistrationDate(), new Integer(fileProperty.getVersion())};
            data.add(objects);
        }
        return (Object[][])data.toArray((T[])new Object[0][]);
    }
}

