/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.lims.webclient.client.application.AsyncCallbackAdapter;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.ui.AbstractLayoutDialog;
import ch.systemsx.cisd.lims.webclient.client.application.utils.DOMUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.BuildInfo;
import ch.systemsx.cisd.lims.webclient.client.dto.User;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.Ext;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.ButtonConfig;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.ToolbarItem;
import com.gwtext.client.widgets.ToolbarMenuButton;
import com.gwtext.client.widgets.ToolbarTextItem;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.layout.ContentPanel;
import com.gwtext.client.widgets.menu.BaseItem;
import com.gwtext.client.widgets.menu.Item;
import com.gwtext.client.widgets.menu.ItemConfig;
import com.gwtext.client.widgets.menu.Menu;
import com.gwtext.client.widgets.menu.event.BaseItemListener;
import com.gwtext.client.widgets.menu.event.BaseItemListenerAdapter;

public class ToolbarPanel
extends ContentPanel {
    private final Toolbar toolbar;
    private final ViewContext viewContext;

    public ToolbarPanel(ViewContext viewContext) {
        super(Ext.generateId());
        this.viewContext = viewContext;
        this.toolbar = new Toolbar(Ext.generateId());
        this.toolbar.addItem((ToolbarItem)this.createUsernameItem());
        this.toolbar.addButton(this.createLogoutButton());
        this.toolbar.addButton(this.createHelpMenu());
        this.add((Widget)this.toolbar);
    }

    private final ToolbarMenuButton createHelpMenu() {
        Menu menu = new Menu(Ext.generateId());
        final IMessageResources messageResources = this.viewContext.getMessageResources();
        Item item = new Item(String.valueOf(messageResources.getHelpMenuAboutLabel()) + "...", new ItemConfig());
        item.addBaseItemListener((BaseItemListener)new BaseItemListenerAdapter(){

            public final void onClick(BaseItem baseItem, EventObject e) {
                AboutDialog aboutDialog = new AboutDialog(messageResources);
                ToolbarPanel.this.viewContext.getLimService().getBuildInfo(new AboutDialogCallback(aboutDialog));
            }
        });
        menu.addItem((BaseItem)item);
        ToolbarMenuButton menuButton = new ToolbarMenuButton(Ext.generateId(), messageResources.getHelpMenuLabel(), menu);
        return menuButton;
    }

    private final ToolbarTextItem createUsernameItem() {
        User user = this.viewContext.getViewModel().getUser();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<b>").append(this.viewContext.getMessageResources().getLoginUsernameLabel());
        buffer.append("</b>: ").append(user.getUserName());
        buffer.append(" (").append(user.getGroupCode()).append(")");
        return new ToolbarTextItem(buffer.toString());
    }

    protected void logoutSuccessful() {
    }

    private final ToolbarButton createLogoutButton() {
        IMessageResources messageResources = this.viewContext.getMessageResources();
        ToolbarButton logoutButton = new ToolbarButton(messageResources.getLogoutLinkLabel(), new ButtonConfig(messageResources){
            {
                this.setTooltip(iMessageResources.getLogoutLinkTooltip());
            }
        });
        logoutButton.addButtonListener((ButtonListener)new LogoutButtonListener());
        return logoutButton;
    }

    private static final class AboutDialog
    extends AbstractLayoutDialog {
        private final ContentPanel contentPanel = new ContentPanel();

        AboutDialog(IMessageResources messageResources) {
            super(messageResources, messageResources.getHelpMenuAboutLabel(), 500, 300, true, true);
            this.addContentPanel();
        }

        protected final Widget createContentWidget() {
            return this.contentPanel;
        }

        final void setContent(String content) {
            this.contentPanel.setContent(content);
        }
    }

    private final class AboutDialogCallback
    extends AbstractAsyncCallback {
        private final AboutDialog aboutDialog;

        AboutDialogCallback(AboutDialog aboutDialog) {
            super(ToolbarPanel.this.viewContext);
            this.aboutDialog = aboutDialog;
        }

        private final String createContent(BuildInfo buildInfo) {
            StringBuffer buffer = new StringBuffer();
            IMessageResources messageResources = ToolbarPanel.this.viewContext.getMessageResources();
            buffer.append(messageResources.getCISDLogoTitle());
            buffer.append(DOMUtils.BR);
            buffer.append(messageResources.getAboutDialogVersionLabel()).append(": ").append(buildInfo.getFullVersion());
            buffer.append(DOMUtils.BR);
            buffer.append(messageResources.getAboutDialogDbVersionLabel()).append(": ").append(buildInfo.getDbVersion());
            buffer.append(DOMUtils.BR);
            buffer.append("Copyright 2007 ETH Zuerich, CISD");
            return buffer.toString();
        }

        public final void onSuccess(Object result) {
            BuildInfo buildInfo = (BuildInfo)result;
            this.aboutDialog.setContent(this.createContent(buildInfo));
            this.aboutDialog.show();
        }
    }

    private final class LogoutButtonListener
    extends ButtonListenerAdapter {
        LogoutButtonListener() {
        }

        public final void onClick(Button button, EventObject e) {
            ToolbarPanel.this.viewContext.getLimService().logout(AsyncCallbackAdapter.EMPTY_ASYNC_CALLBACK);
            ToolbarPanel.this.logoutSuccessful();
        }
    }
}

