/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.ui;

import ch.systemsx.cisd.lims.webclient.client.application.ColumnView;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;

public class SimpleTable
extends Composite {
    private static final int DEFAULT_NUMBER_OF_ROWS_VISIBLE = 10;
    private final ColumnView[] columnViews;
    private final int numberOfRowsVisible;
    private final int numberOfRows;
    private final DockPanel dockPanel;
    private final Grid grid;
    private HTML pageInfo;
    private Button showFirstButton;
    private Button showPreviousButton;
    private Button showNextButton;
    private Button showLastButton;
    private int indexOfFirstRow = -1;

    public SimpleTable(int numberOfVisibleRows, ColumnView[] columnViews) {
        this.columnViews = columnViews;
        this.numberOfRowsVisible = numberOfVisibleRows < 0 ? 10 : numberOfVisibleRows;
        this.numberOfRows = this.getNumberOfRows();
        this.dockPanel = new DockPanel();
        this.grid = new Grid();
        this.grid.setCellSpacing(0);
        this.dockPanel.add((Widget)this.grid, DockPanel.CENTER);
        if (this.numberOfRows > numberOfVisibleRows) {
            this.dockPanel.add(this.createPagingBar(), DockPanel.SOUTH);
        }
        this.initWidget((Widget)this.dockPanel);
        this.showFirstPage();
    }

    private int getNumberOfRows() throws AssertionError {
        int result = 0;
        int i = 0;
        while (i < this.columnViews.length) {
            int numberOfValues = this.columnViews[i].getNumberOfElements();
            if (i > 0 && numberOfValues != result) {
                throw new AssertionError((Object)("Column " + i + " has " + numberOfValues + " instead of " + result));
            }
            result = numberOfValues;
            ++i;
        }
        return result;
    }

    private Widget createPagingBar() {
        DockPanel bar = new DockPanel();
        HorizontalPanel panel = new HorizontalPanel();
        bar.add((Widget)panel, DockPanel.EAST);
        this.pageInfo = new HTML();
        panel.add((Widget)this.pageInfo);
        ClickListener buttonListener = this.createButtonListener();
        this.showFirstButton = this.createButton((Panel)panel, "&lt;&lt;", buttonListener);
        this.showPreviousButton = this.createButton((Panel)panel, "&lt;", buttonListener);
        this.showNextButton = this.createButton((Panel)panel, "&gt;", buttonListener);
        this.showLastButton = this.createButton((Panel)panel, "&gt;&gt;", buttonListener);
        return bar;
    }

    private ClickListener createButtonListener() {
        return new ClickListener(){

            public void onClick(Widget sender) {
                if (sender == SimpleTable.this.showFirstButton) {
                    SimpleTable.this.showFirstPage();
                } else if (sender == SimpleTable.this.showPreviousButton) {
                    SimpleTable.this.showPreviousPage();
                } else if (sender == SimpleTable.this.showNextButton) {
                    SimpleTable.this.showNextPage();
                } else if (sender == SimpleTable.this.showLastButton) {
                    SimpleTable.this.showLastPage();
                }
            }
        };
    }

    private Button createButton(Panel buttonPanel, String label, ClickListener listener) {
        Button button = new Button(label, listener);
        buttonPanel.add((Widget)button);
        return button;
    }

    void showFirstPage() {
        if (this.indexOfFirstRow != 0) {
            this.indexOfFirstRow = 0;
            this.refresh();
        }
    }

    void showPreviousPage() {
        if (this.indexOfFirstRow > 0) {
            this.indexOfFirstRow = Math.max(0, this.indexOfFirstRow - this.numberOfRowsVisible);
            this.refresh();
        }
    }

    void showNextPage() {
        if (this.indexOfFirstRow + this.numberOfRowsVisible < this.numberOfRows) {
            this.indexOfFirstRow += this.numberOfRowsVisible;
            this.refresh();
        }
    }

    void showLastPage() {
        if (this.indexOfFirstRow < this.numberOfRows - this.numberOfRowsVisible) {
            this.indexOfFirstRow = Math.max(0, this.numberOfRows - this.numberOfRowsVisible);
            this.refresh();
        }
    }

    private void refresh() {
        int actualNumberOfRows = Math.min(this.numberOfRows - this.indexOfFirstRow, this.numberOfRowsVisible);
        this.grid.resize(actualNumberOfRows + 1, this.columnViews.length);
        int i = 0;
        while (i < this.columnViews.length) {
            this.grid.setText(0, i, this.columnViews[i].getTitle());
            this.grid.getCellFormatter().setStylePrimaryName(0, i, "simple-table-header-td");
            ++i;
        }
        int rowIndex = 1;
        while (rowIndex <= actualNumberOfRows) {
            String styleClass = rowIndex % 2 == 0 ? "simple-table-odd-row" : "simple-table-even-row";
            this.grid.getRowFormatter().setStyleName(rowIndex, styleClass);
            ++rowIndex;
        }
        int colIndex = 0;
        while (colIndex < this.columnViews.length) {
            ColumnView columnView = this.columnViews[colIndex];
            int rowIndex2 = 1;
            while (rowIndex2 <= actualNumberOfRows) {
                int index = rowIndex2 + this.indexOfFirstRow - 1;
                if (columnView.isTextual()) {
                    this.grid.setText(rowIndex2, colIndex, columnView.getElement(index));
                } else {
                    this.grid.setWidget(rowIndex2, colIndex, columnView.createWidget(index));
                }
                this.grid.getCellFormatter().setStylePrimaryName(rowIndex2, colIndex, "simple-table-td");
                ++rowIndex2;
            }
            ++colIndex;
        }
    }
}

