/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.lims.base.server.Role;
import ch.systemsx.cisd.lims.base.server.Roles;
import ch.systemsx.cisd.lims.server.business.IRolesManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultRolesManager
implements IRolesManager {
    private final Map<String, Set<Role>> methodMap;
    private final Map<String, Set<Role>> userMap;
    private final Set<Role> defaultRoles;

    public DefaultRolesManager(Class<?> interfaceToGuard, List<String> userRoleDefinition) {
        this(DefaultRolesManager.createMethodMap(interfaceToGuard), DefaultRolesManager.getUserRoles(userRoleDefinition), DefaultRolesManager.getDefaultUserRoles(userRoleDefinition));
    }

    public DefaultRolesManager(Map<String, Set<Role>> methodMap, Map<String, Set<Role>> userMap, Set<Role> defaultRoles) {
        this.methodMap = methodMap;
        this.userMap = userMap;
        this.defaultRoles = Collections.unmodifiableSet(defaultRoles);
    }

    private static final Map<String, Set<Role>> createMethodMap(Class<?> interfaceToGuard) {
        assert (interfaceToGuard != null) : "Given interface to guard can not be null.";
        HashMap<String, Set<Role>> methodMap = new HashMap<String, Set<Role>>();
        Method[] methodArray = interfaceToGuard.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Roles roles = method.getAnnotation(Roles.class);
            if (roles != null) {
                methodMap.put(method.getName(), new HashSet(Arrays.asList(roles.value())));
            }
            ++n2;
        }
        return methodMap;
    }

    private static final Map<String, Set<Role>> getUserRoles(List<String> userRoleDefinition) {
        assert (userRoleDefinition != null) : "Given user role definition can not be null.";
        HashMap<String, Set<Role>> userMap = new HashMap<String, Set<Role>>();
        boolean foundRoles = false;
        for (String line : userRoleDefinition) {
            String trimmed = line.trim();
            if (trimmed.length() == 0 || trimmed.charAt(0) == '#') continue;
            if (!foundRoles) {
                if (!"[Roles]".equals(trimmed)) continue;
                foundRoles = true;
                continue;
            }
            if (trimmed.charAt(0) == '[') break;
            DefaultRolesManager.processRolesLine(userMap, line);
        }
        return userMap;
    }

    private static void processRolesLine(Map<String, Set<Role>> userMap, String line) {
        String[] users;
        String[] keyValues = StringUtils.split(line, '=');
        if (keyValues.length != 2) {
            throw ConfigurationFailureException.fromTemplate("Illegal line '%s': no key-value pair found.", line);
        }
        Role role = DefaultRolesManager.getRole(keyValues[0], line);
        String[] stringArray = users = StringUtils.split(keyValues[1], ',');
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            DefaultRolesManager.addRole(userMap, user.trim(), role);
            ++n2;
        }
    }

    private static final Role getRole(String roleStr, String line) {
        String trimmedRoleStr = roleStr.trim().toUpperCase();
        try {
            return Role.valueOf(trimmedRoleStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ConfigurationFailureException.fromTemplate("Illegal line '%s': illegal role '%s'.", line, trimmedRoleStr);
        }
    }

    private static final void addRole(Map<String, Set<Role>> userRoles, String user, Role role) {
        Set<Role> roleSet = userRoles.get(user);
        if (roleSet == null) {
            roleSet = new HashSet<Role>();
            userRoles.put(user, roleSet);
        }
        roleSet.add(role);
    }

    private static final Set<Role> getDefaultUserRoles(List<String> userRoleDefinition) {
        HashSet<Role> defaultSet = new HashSet<Role>();
        boolean foundDefaultRoles = false;
        for (String line : userRoleDefinition) {
            String trimmed = line.trim();
            if (trimmed.length() == 0 || trimmed.charAt(0) == '#') continue;
            if (!foundDefaultRoles) {
                if (!"[DefaultRoles]".equals(trimmed)) continue;
                foundDefaultRoles = true;
                continue;
            }
            if (trimmed.charAt(0) == '[') break;
            defaultSet.add(DefaultRolesManager.getRole(line, line));
        }
        return defaultSet;
    }

    @Override
    public final Set<Role> getMethodRoles(String methodname) {
        assert (methodname != null) : "Given method name can not be null.";
        Set<Role> roleSet = this.methodMap.get(methodname);
        assert (roleSet != null) : String.format("Role set for method name '%d' can not be null.", methodname);
        return Collections.unmodifiableSet(roleSet);
    }

    @Override
    public final Set<Role> getUserRoles(String username) {
        assert (username != null) : "Given user name can not be null.";
        Set<Role> userRoles = this.userMap.get(username);
        if (userRoles == null) {
            return this.defaultRoles;
        }
        return Collections.unmodifiableSet(userRoles);
    }
}

