/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication;

import ch.systemsx.cisd.common.utilities.AbstractHashable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Principal
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final Map<String, String> properties;

    public Principal(String userId, String firstName, String lastName, String email) {
        this(userId, firstName, lastName, email, Collections.emptyMap());
    }

    public Principal(String userId, String firstName, String lastName, String email, Map<String, String> properties) {
        assert (userId != null);
        assert (firstName != null);
        assert (lastName != null);
        assert (email != null);
        assert (properties != null);
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.properties = properties;
    }

    public String getUserId() {
        return this.userId;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getFirstName() {
        return this.firstName;
    }

    public final String getLastName() {
        return this.lastName;
    }

    public final String getProperty(String key) {
        return this.properties.get(key);
    }

    public final Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

