/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.common.utilities.PasswordHasher;
import org.apache.commons.lang.StringUtils;

class UserEntry
extends AbstractHashable {
    private static final int NUMBER_OF_COLUMNS_IN_PASSWORD_FILE = 5;
    private static final int USER_ID_IDX = 0;
    private static final int EMAIL_IDX = 1;
    private static final int FIRST_NAME_IDX = 2;
    private static final int LAST_NAME_IDX = 3;
    private static final int PASSWORD_IDX = 4;
    private final String[] passwordFileEntry;

    UserEntry(String passwordFileLine) throws IllegalArgumentException {
        this.passwordFileEntry = UserEntry.split(passwordFileLine);
    }

    private static String[] split(String passwordFileLine) throws IllegalArgumentException {
        assert (passwordFileLine != null);
        String[] entry = passwordFileLine.split(":");
        if (entry.length != 5) {
            String msg = String.format("Password line is ill-formatted: '%s'", passwordFileLine);
            throw new IllegalArgumentException(msg);
        }
        return entry;
    }

    UserEntry(String userId, String email, String firstName, String lastName, String password) {
        assert (userId != null);
        assert (email != null);
        assert (firstName != null);
        assert (lastName != null);
        assert (password != null);
        this.passwordFileEntry = new String[]{userId, email, firstName, lastName, PasswordHasher.computeSaltedHash(password)};
    }

    String asPasswordLine() {
        return StringUtils.join((Object[])this.passwordFileEntry, ':');
    }

    Principal asPrincial() {
        return new Principal(this.getUserId(), this.getFirstName(), this.getLastName(), this.getEmail());
    }

    String getUserId() {
        return this.passwordFileEntry[0];
    }

    String getEmail() {
        return this.passwordFileEntry[1];
    }

    void setEmail(String email) {
        assert (email != null);
        this.passwordFileEntry[1] = email;
    }

    String getFirstName() {
        return this.passwordFileEntry[2];
    }

    void setFirstName(String firstName) {
        assert (firstName != null);
        this.passwordFileEntry[2] = firstName;
    }

    String getLastName() {
        return this.passwordFileEntry[3];
    }

    void setLastName(String lastName) {
        assert (lastName != null);
        this.passwordFileEntry[3] = lastName;
    }

    private String getPasswordHash() {
        return this.passwordFileEntry[4];
    }

    void setPassword(String plainPassword) {
        assert (StringUtils.isNotBlank(plainPassword));
        this.passwordFileEntry[4] = PasswordHasher.computeSaltedHash(plainPassword);
    }

    boolean isPasswordCorrect(String password) {
        return PasswordHasher.isPasswordCorrect(password, this.getPasswordHash());
    }
}

