/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.Script;
import ch.systemsx.cisd.common.db.ISqlScriptExecutionLogger;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.DBUtilities;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class SqlScriptExecutor
extends JdbcDaoSupport
implements ISqlScriptExecutor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SqlScriptExecutor.class);
    private final boolean singleStepMode;

    public SqlScriptExecutor(DataSource dataSource, boolean singleStepMode) {
        this.setDataSource(dataSource);
        this.singleStepMode = singleStepMode;
    }

    public void execute(Script sqlScript, boolean honorSingleStepMode, ISqlScriptExecutionLogger loggerOrNull) {
        if (loggerOrNull != null) {
            loggerOrNull.logStart(sqlScript);
        }
        try {
            String sqlScriptCode = sqlScript.getCode();
            if (this.singleStepMode && honorSingleStepMode) {
                String lastSqlStatement = "";
                for (String sqlStatement : DBUtilities.splitSqlStatements(sqlScriptCode)) {
                    try {
                        this.execute(sqlStatement);
                    }
                    catch (BadSqlGrammarException ex2) {
                        throw new BadSqlGrammarException(this.getTask(ex2), String.valueOf(lastSqlStatement) + ">-->" + sqlStatement + "<--<", this.getCause((DataAccessException)((Object)ex2)));
                    }
                    catch (UncategorizedSQLException ex2) {
                        throw new UncategorizedSQLException(this.getTask(ex2), String.valueOf(lastSqlStatement) + ">-->" + sqlStatement + "<--<", this.getCause((DataAccessException)((Object)ex2)));
                    }
                    lastSqlStatement = sqlStatement;
                }
            } else {
                this.execute(sqlScriptCode);
            }
            if (loggerOrNull != null) {
                loggerOrNull.logSuccess(sqlScript);
            }
        }
        catch (Throwable t) {
            operationLog.error("Executing script '" + sqlScript.getName() + "', version " + sqlScript.getVersion() + " failed.", t);
            if (loggerOrNull != null) {
                loggerOrNull.logFailure(sqlScript, t);
            }
            if (t instanceof Error) {
                Error error = (Error)t;
                throw error;
            }
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)t);
        }
    }

    void execute(String script) {
        this.getJdbcTemplate().execute(script);
    }

    private String getTask(BadSqlGrammarException ex) {
        return this.getTask((RuntimeException)((Object)ex), "; bad SQL grammar [");
    }

    private String getTask(UncategorizedSQLException ex) {
        return this.getTask((RuntimeException)((Object)ex), "; uncategorized SQLException for SQL [");
    }

    private String getTask(RuntimeException ex, String marker) {
        String msg = ex.getMessage();
        int endIdx = msg.indexOf(marker);
        if (endIdx > 0) {
            return msg.substring(0, endIdx);
        }
        return msg;
    }

    private SQLException getCause(DataAccessException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof SQLException) {
            return (SQLException)cause;
        }
        throw new Error("Cause of DataAccessException needs to be a SQLException.", cause);
    }
}

