/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.base;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExperimentPlatesFilter;
import ch.systemsx.cisd.lims.base.LimitFilter;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.MoleculeCriteria;
import ch.systemsx.cisd.lims.base.NewExperiment;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.base.NewSampleComponentWithFixedMaterialType;
import ch.systemsx.cisd.lims.base.ProcessingInstruction;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.base.SampleFilter;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import java.util.Date;
import org.apache.commons.lang.time.DurationFormatUtils;

public final class LogMessageProvider {
    private static final String AND_SO_ON = " ,...";
    private static final String SHOW_N_OUT_OF_M = "[showing %s out of %s]:";
    private static final int DEFAULT_NUMBER_OF_ELEMENTS_TO_SHOW = 3;
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String LIST_PROPERTY_TYPED_ENTITIES = "list_property_typed_entities";
    private static final String GET_SAMPLE_LAYOUT = "get_sample_layout";
    private static final String REGISTER_VOCABULARY = "register_vocabulary";
    private static final String REGISTER_SAMPLES = "register_samples";
    private static final String LIST_VOCABULARY_TERMS = "list_vocabulary_terms";
    private static final String LIST_VOCABULARIES = "list_vocabularies";
    private static final String GET_PLATE_DIMENSION = "get_plate_dimension";
    private static final String LIST_SAMPLES = "list_samples";
    private static final String UNASSIGN_ENTITY_PROPERTY_TYPE = "unassign_entity_property_type";
    private static final String REGISTER_PROPERTY_TYPES = "register_property_types";
    private static final String REGISTER_PROJECT = "register_project";
    private static final String REGISTER_MATERIALS = "register_materials";
    private static final String REGISTER_MASTER_PLATE = "register_master_plate";
    private static final String REGISTER_EXPERIMENTS = "register_experiments";
    private static final String REGISTER_CONTROL_LAYOUT = "register_control_layout";
    private static final String LIST_PROPERTY_TYPES = "list_property_types";
    private static final String LIST_PROJECTS = "list_projects";
    private static final String LIST_MATERIALS = "list_materials";
    private static final String LIST_MATERIAL_TYPES = "list_material_types";
    private static final String LIST_EXPERIMENTS = "list_experiments";
    private static final String LIST_EXPERIMENT_TYPES = "list_experiment_types";
    private static final String LIST_CONTACTS = "list_contacts";
    private static final String INVALIDATE_SAMPLES = "invalidate_samples";
    private static final String INVALIDATE_EXPERIMENT = "invalidate_experiment";
    private static final String GET_PLATE_LOCATIONS = "get_plate_locations";
    private static final String GET_SAMPLE_INFO = "get_sample_info";
    private static final String GET_DATA_SET = "get_data_set";
    private static final String GET_ENTITY_TYPE_INFO = "get_%s_type_info";
    private static final String GET_EXPERIMENT_INFO_BASIC = "get_experiment_info";
    private static final String GET_EXPERIMENT_INFO_WITH_DATASETS = "get_experiment_datasets_info";
    private static final String GET_EXPERIMENT_INFO_WITH_PLATES = "get_experiment_plates_info";
    private static final String GET_EXPERIMENT_ATTACHMENT = "get_experiment_attachment";
    private static final String ASSIGN_ENTITY_PROPERTY = "assign_entity_property";
    private static final String ADD_EXPERIMENT_ATTACHMENT = "add_experiment_attachment";
    private static final String LOGOUT = "logout";
    private static final String SESSION_EXPIRED = "session_expired";
    private static final String LOGIN = "login";
    private static final String LIST_SAMPLE_TYPES = "list_sample_types";
    private static final String UNDEFINED = "<UNDEFINED>";
    private final String username;
    private final String groupCode;
    private final boolean invocationSuccessful;
    private static final String RESULT_SUCCESS = "";
    private static final String RESULT_FAILURE = " ...FAILED";

    public LogMessageProvider(String username, String groupCode, boolean invocationSuccessful) {
        this.username = username;
        this.groupCode = groupCode;
        this.invocationSuccessful = invocationSuccessful;
    }

    private String getInvocationStatusMessage() {
        return this.invocationSuccessful ? RESULT_SUCCESS : RESULT_FAILURE;
    }

    private String createMessage(String commandName, String parameterDisplayFormat, Object ... parameters) {
        String message = String.format(parameterDisplayFormat, parameters);
        return String.format("[USER:%s GROUP:%s]: %s  %s%s", LogMessageProvider.cite(this.username), LogMessageProvider.cite(this.groupCode), commandName, message, this.getInvocationStatusMessage());
    }

    private String createMessage(String commandName) {
        return this.createMessage(commandName, RESULT_SUCCESS, new Object[0]);
    }

    public String login() {
        return this.createMessage(LOGIN);
    }

    public String logout(long start) {
        long time = System.currentTimeMillis() - start;
        return this.createMessage(LOGOUT, "[active %s]", DurationFormatUtils.formatDurationHMS(time));
    }

    public final String createSessionExpiredMessage(long inactive) {
        return this.createMessage(SESSION_EXPIRED, "[inactive %s]", DurationFormatUtils.formatDurationHMS(inactive));
    }

    public String addExperimentAttachment(ExperimentIdentifier experimentIdentifier, ExperimentFileAttachment property) {
        String filename = RESULT_SUCCESS;
        String length = RESULT_SUCCESS;
        String version = RESULT_SUCCESS;
        if (property != null && property.getFileProperty() != null) {
            filename = LogMessageProvider.cite(property.getFileProperty().getFileName());
            version = LogMessageProvider.cite(String.valueOf(property.getFileProperty().getVersion()));
        }
        if (property != null && property.getValue() != null) {
            length = LogMessageProvider.cite(String.valueOf(property.getValue().length()));
        }
        return this.createMessage(ADD_EXPERIMENT_ATTACHMENT, "%s ATTACHMENT(name:%s, length:%s, version:%s)", experimentIdentifier, filename, length, version);
    }

    public final String assignEntityPropertyType(EntityKind entityKind, String entityTypeCode, String propertyName, boolean mandatory, EntityPropertyFiller[] propertyFillers) {
        String mandatoryString = LogMessageProvider.booleanToString(mandatory);
        return this.createMessage(ASSIGN_ENTITY_PROPERTY, "KIND(%s) %s PROPERTY(%s) MANDATORY(%s) VALUES(%s)", entityKind.name(), LogMessageProvider.printEntityTypeCodeToString(entityKind, entityTypeCode), LogMessageProvider.cite(propertyName), mandatoryString, LogMessageProvider.tableToString(propertyFillers));
    }

    private static String printEntityTypeCodeToString(EntityKind entityKind, String entityTypeCode) {
        return LogMessageProvider.describedValueToString("%s_TYPE(%s) ", entityKind.name(), LogMessageProvider.cite(entityTypeCode));
    }

    private static final String describedValueToString(String format, String ... values) {
        if (values == null) {
            return RESULT_SUCCESS;
        }
        return String.format(format, values);
    }

    private static String booleanToString(boolean value) {
        if (value) {
            return YES;
        }
        return NO;
    }

    public String getExperimentAttachment(ExperimentIdentifier experimentIdentifier, String filename, int version) {
        return this.createMessage(GET_EXPERIMENT_ATTACHMENT, "%s ATTACHMENT(%s) VERSION(%s)", experimentIdentifier, filename, version);
    }

    public String getExperimentInfoBasic(ExperimentIdentifier experimentIdentifier) {
        return this.createMessage(GET_EXPERIMENT_INFO_BASIC, "%s", experimentIdentifier);
    }

    public String getExperimentInfoWithDatasets(ExperimentIdentifier experimentIdentifier) {
        return this.createMessage(GET_EXPERIMENT_INFO_WITH_DATASETS, "%s", experimentIdentifier);
    }

    public String getExperimentInfoWithPlates(ExperimentIdentifier experimentIdentifier, ExperimentPlatesFilter filter) {
        return this.createMessage(GET_EXPERIMENT_INFO_WITH_PLATES, "%s FILTER(%S)", experimentIdentifier, filter);
    }

    public String getEntityTypeInfo(String materialTypeCode, EntityKind entityKind) {
        String entityKindStr = entityKind != null ? entityKind.getLabel() : RESULT_SUCCESS;
        String command = String.format(GET_ENTITY_TYPE_INFO, entityKindStr);
        return this.createMessage(command, "%s", LogMessageProvider.cite(materialTypeCode));
    }

    public final String getSampleInfo(String sampleCode) {
        return this.createMessage(GET_SAMPLE_INFO, "%s", LogMessageProvider.cite(sampleCode));
    }

    public final String getDataSet(String dataSetCode) {
        return this.createMessage(GET_DATA_SET, "%s", LogMessageProvider.cite(dataSetCode));
    }

    public String getPlateLocations(ExperimentIdentifier experimentIdentifier, MoleculeCriteria criteria, boolean showInvalidated) {
        String showInvalidatedStr = showInvalidated ? YES : NO;
        String gene = criteria.getGeneSymbol();
        String materialCode = criteria.getCode();
        String materialType = criteria.getTypeCode();
        materialCode = LogMessageProvider.cite(materialCode);
        materialType = LogMessageProvider.cite(materialType);
        return this.createMessage(GET_PLATE_LOCATIONS, "%s GENE(%s) MATERIAL(code:%s, type:%s) SHOW_INVALID(%s)", experimentIdentifier, LogMessageProvider.cite(gene), LogMessageProvider.cite(materialCode), LogMessageProvider.cite(materialType), showInvalidatedStr);
    }

    public String invalidateExperiment(ExperimentIdentifier experimentIdentifier, String invalidationReasonOrNull) {
        String reasonStr = LogMessageProvider.cite(invalidationReasonOrNull);
        return this.createMessage(INVALIDATE_EXPERIMENT, "%s REASON(%s)", experimentIdentifier, reasonStr);
    }

    public final String invalidateSamples(String[] sampleCodes, String invalidationReasonOrNull) {
        String reasonStr = LogMessageProvider.cite(invalidationReasonOrNull);
        return this.createMessage(INVALIDATE_SAMPLES, "%s REASON(%s)", LogMessageProvider.tableToString(sampleCodes), reasonStr);
    }

    public String listContacts() {
        return this.createMessage(LIST_CONTACTS);
    }

    public String listExperimentTypes() {
        return this.createMessage(LIST_EXPERIMENT_TYPES);
    }

    public String listExperiments(QueryRestriction queryRestriction) {
        return this.createMessage(LIST_EXPERIMENTS, "%s", LogMessageProvider.queryRestrictionToString(queryRestriction));
    }

    public String listMaterialTypes() {
        return this.createMessage(LIST_MATERIAL_TYPES);
    }

    public String listMaterials(String materialTypeCode, String[] codePatterns, LimitFilter limitFilter) {
        String codePatternStr = LogMessageProvider.describedValueToString("CODE_PATTERN(%s) ", LogMessageProvider.cite(CollectionUtils.abbreviate(codePatterns, -1)));
        return this.createMessage(LIST_MATERIALS, "%s%s%s", LogMessageProvider.printEntityTypeCodeToString(EntityKind.MATERIAL, materialTypeCode), codePatternStr, LogMessageProvider.limitFilterToString(limitFilter));
    }

    public String listProjects() {
        return this.createMessage(LIST_PROJECTS);
    }

    public final String listPropertyTypes(EntityKind entityKindOrNull) {
        if (entityKindOrNull != null) {
            return this.createMessage(LIST_PROPERTY_TYPES, "KIND(%s)", LogMessageProvider.cite(entityKindOrNull.name()));
        }
        return this.createMessage(LIST_PROPERTY_TYPES);
    }

    public String registerControlLayout(String sampleCode, NewSampleComponentWithFixedMaterialType[] sampleComponents) {
        return this.createMessage(REGISTER_CONTROL_LAYOUT, "%s %s", LogMessageProvider.cite(sampleCode), LogMessageProvider.tableToString(sampleComponents));
    }

    public String registerExperiments(NewExperiment[] experimentsToRegister) {
        return this.createMessage(REGISTER_EXPERIMENTS, "%s", LogMessageProvider.tableToString(experimentsToRegister));
    }

    public String registerMasterPlate(String sampleCode, NewSampleComponent[] sampleComponents, String materialBatchCode, String controlLayoutCodeOrNull) {
        return this.createMessage(REGISTER_MASTER_PLATE, "CODE(%s) MATERIAL_BATCH_CODE(%s) CONTROL_LAYOUT(%s)", LogMessageProvider.cite(sampleCode), LogMessageProvider.cite(materialBatchCode), LogMessageProvider.cite(controlLayoutCodeOrNull), LogMessageProvider.tableToString(sampleComponents));
    }

    public String registerMaterials(Material[] materials, String materialTypeCode) {
        return this.createMessage(REGISTER_MATERIALS, "TYPE(%s) %s", LogMessageProvider.cite(materialTypeCode), LogMessageProvider.tableToString(materials));
    }

    public String registerProject(String projectCode) {
        return this.createMessage(REGISTER_PROJECT, "%s", LogMessageProvider.cite(projectCode));
    }

    public String registerPropertyTypes(PropertyType[] properties) {
        return this.createMessage(REGISTER_PROPERTY_TYPES, "%s", LogMessageProvider.tableToString(properties));
    }

    public final String unassignEntityPropertyType(EntityKind entityKind, String entityTypeCode, String propertyTypeCode) {
        return this.createMessage(UNASSIGN_ENTITY_PROPERTY_TYPE, "%s_TYPE(%s) PROPERTY_TYPE(%s)", entityKind.name(), LogMessageProvider.cite(entityTypeCode), LogMessageProvider.cite(propertyTypeCode));
    }

    public String listSamples(String sampleTypeCode, SampleFilter filter, LimitFilter limitFilter, boolean enrichWithRelations) {
        String enrichWithRelationsStr = enrichWithRelations ? YES : NO;
        String filterStr = LogMessageProvider.filterToString(filter);
        return this.createMessage(LIST_SAMPLES, "TYPE(%s) %s %s WITH_RELATIONS(%s)", LogMessageProvider.cite(sampleTypeCode), filterStr, LogMessageProvider.limitFilterToString(limitFilter), enrichWithRelationsStr);
    }

    private static String limitFilterToString(LimitFilter limitFilter) {
        if (limitFilter == null) {
            return RESULT_SUCCESS;
        }
        String limit = "<NO LIMIT>";
        if (limitFilter.getLimit() > -1) {
            limit = String.format("LIMIT(%s)", limitFilter.getLimit());
        }
        int start = limitFilter.getStart();
        return String.format("%s START(%s)", limit, start);
    }

    private static String filterToString(SampleFilter filter) {
        if (filter == null || filter.getPatterns().length == 0) {
            return "<NO FILTER>";
        }
        String showInvalid = filter.isHideInvalidated() ? NO : YES;
        return String.format("FILTER(%s) SHOW_INVALID(%s) ", LogMessageProvider.cite(CollectionUtils.abbreviate(filter.getPatterns(), -1)), showInvalid);
    }

    public final String getPlateDimension(String sampleCode) {
        return this.createMessage(GET_PLATE_DIMENSION, "%s", LogMessageProvider.cite(sampleCode));
    }

    public String listVocabularies() {
        return this.createMessage(LIST_VOCABULARIES);
    }

    public String listVocabularyTerms(String vocabularyCode) {
        return this.createMessage(LIST_VOCABULARY_TERMS, "VOCABULARY_CODE(%s)", LogMessageProvider.cite(vocabularyCode));
    }

    public final String registerSamples(NewSample[] samples) {
        return this.createMessage(REGISTER_SAMPLES, "%s", LogMessageProvider.tableToString(samples));
    }

    public String registerVocabulary(String vocabularyName, String vocabularyDescOrNull, String[] vocabularyTerms, boolean addTerms) {
        return this.createMessage(REGISTER_VOCABULARY, "%s GROUP(%s) DESCRITTION(%s) TERMS(%s) ADD_TERMS(%s)", LogMessageProvider.cite(vocabularyName), LogMessageProvider.cite(this.groupCode), LogMessageProvider.cite(vocabularyDescOrNull), LogMessageProvider.tableToString(vocabularyTerms), addTerms ? "YES" : "NO");
    }

    public final String getSampleLayout(String sampleCode) {
        return this.createMessage(GET_SAMPLE_LAYOUT, "SAMPLE(%s)", LogMessageProvider.cite(sampleCode));
    }

    public final String listPropertyTypedEntities(String entityKindName, String entityTypeCode, String propertyTypeCode) {
        return this.createMessage(LIST_PROPERTY_TYPED_ENTITIES, "KIND(%s) CODE(%s) PROPERTY(%s)", LogMessageProvider.cite(entityKindName), LogMessageProvider.cite(entityTypeCode), LogMessageProvider.cite(propertyTypeCode));
    }

    private static String newExperimentToString(NewExperiment e) {
        StringBuilder str = new StringBuilder();
        if (e.getProjectCode() != null) {
            str.append(String.format("PROJECT(%s) ", LogMessageProvider.cite(e.getProjectCode())));
        }
        if (e.getCode() != null) {
            str.append(String.format("CODE(%s) ", LogMessageProvider.cite(e.getCode())));
        }
        if (e.getControlLayoutCode() != null) {
            str.append(String.format("CONTROL_LAYOUT(%s) ", LogMessageProvider.cite(e.getControlLayoutCode())));
        }
        if (e.getDescription() != null) {
            str.append(String.format("DESCRIPTION(%s) ", LogMessageProvider.cite(e.getDescription())));
        }
        if (e.getExperimentTypeCode() != null) {
            str.append(String.format("EXPERIMENT_CODE(%s) ", LogMessageProvider.cite(e.getExperimentTypeCode())));
        }
        if (e.getStudyObjectCode() != null) {
            str.append(String.format("STUDY_OBJECT_CODE(%s) ", LogMessageProvider.cite(e.getStudyObjectCode())));
        }
        if (e.getStudyObjectTypeCode() != null) {
            str.append(String.format("STUDY_OBJECT_TYPE_CODE(%s) ", LogMessageProvider.cite(e.getStudyObjectTypeCode())));
        }
        if (e.getCellPlates() != null) {
            str.append(String.format("CELL_PLATES(%s) ", LogMessageProvider.tableToString(e.getCellPlates())));
        }
        if (e.getProcessingInstructions() != null && e.getProcessingInstructions().length > 0) {
            str.append(String.format("PROCESSING_INSTRUCTIONS(%s) ", LogMessageProvider.tableToString(e.getProcessingInstructions())));
        }
        return str.toString();
    }

    private static String tableToString(ProcessingInstruction[] table) {
        return LogMessageProvider.tableToString(table, new Converter<ProcessingInstruction>(){

            @Override
            public String toString(ProcessingInstruction o) {
                String path = LogMessageProvider.cite(o.getPath());
                String desc = LogMessageProvider.cite(o.getDescription());
                String file = LogMessageProvider.UNDEFINED;
                if (o.getParameters() != null) {
                    file = LogMessageProvider.cite(o.getParameters().getFileName());
                }
                String proc = LogMessageProvider.cite(o.getProcedureTypeCode());
                return String.format("FILE(%s) PATH(%s) DESCRIPTION(%s) PROCEDURE_TYPE(%s)", file, path, desc, proc);
            }
        });
    }

    private static String queryRestrictionToString(QueryRestriction queryRestriction) {
        if (queryRestriction == null) {
            return RESULT_SUCCESS;
        }
        StringBuilder str = new StringBuilder();
        String project = queryRestriction.getProjectCode();
        Date from = null;
        Date until = null;
        if (queryRestriction.getTimeInterval() != null) {
            from = queryRestriction.getTimeInterval().getFrom();
            until = queryRestriction.getTimeInterval().getUntil();
        }
        str.append(String.format("EXPERIMENT_TYPE(%s) ", LogMessageProvider.cite(queryRestriction.getExperimentTypeCode())));
        if (project != null) {
            str.append(String.format("PROJECT(%s) ", LogMessageProvider.cite(project)));
        }
        if (from != null) {
            str.append(String.format("FROM(%s) ", from));
        }
        if (until != null) {
            str.append(String.format("UNTIL(%s) ", until));
        }
        if (queryRestriction.getMaterialCriteria() != null) {
            if (queryRestriction.getMaterialCriteria().getCode() != null) {
                str.append(String.format("MATERIAL(%s) ", LogMessageProvider.cite(queryRestriction.getMaterialCriteria().getCode())));
            }
            if (queryRestriction.getMaterialCriteria().getTypeCode() != null) {
                str.append(String.format("MATERIAL_TYPE(%s) ", LogMessageProvider.cite(queryRestriction.getMaterialCriteria().getTypeCode())));
            }
        }
        String showInvalid = queryRestriction.isSuppressInvalidated() ? NO : YES;
        str.append(String.format("SHOW_INVALID(%s) ", showInvalid));
        return str.toString();
    }

    private static String tableToString(NewSample[] table) {
        return LogMessageProvider.tableToString(table, new Converter<NewSample>(){

            @Override
            public String toString(NewSample o) {
                return String.format("CODE(%s), CONTROL_LAYOUT(%s), GENERATED_FROM(%s), TYPE(%s)", LogMessageProvider.cite(o.getSampleCriteria()), LogMessageProvider.cite(o.getControlLayoutCode()), LogMessageProvider.cite(o.getGeneratedFrom()), LogMessageProvider.cite(o.getSampleTypeCode()));
            }
        });
    }

    private static String tableToString(Material[] table) {
        return LogMessageProvider.tableToString(table, new Converter<Material>(){

            @Override
            public String toString(Material o) {
                String code = o.getCode();
                return String.format("%s", LogMessageProvider.cite(code));
            }
        });
    }

    private static String tableToString(PropertyType[] table) {
        return LogMessageProvider.tableToString(table, new Converter<PropertyType>(){

            @Override
            public String toString(PropertyType o) {
                String desc = o.getDescription();
                String name = o.getCode();
                String type = o.getType();
                String label = o.getUserLabel();
                String voc = o.getVocabularyCode();
                return String.format("NAME(%s) TYPE(%s) LABEL(%s) VOCABULARY_CODE(%s) DESCRIPTION(%s)", LogMessageProvider.cite(name), LogMessageProvider.cite(type), LogMessageProvider.cite(label), LogMessageProvider.cite(voc), LogMessageProvider.cite(desc));
            }
        });
    }

    private static String tableToString(EntityPropertyFiller[] table) {
        return LogMessageProvider.tableToString(table, new Converter<EntityPropertyFiller>(){

            @Override
            public String toString(EntityPropertyFiller o) {
                return String.format("%s:%s", LogMessageProvider.cite(o.getEntityCode()), LogMessageProvider.cite(o.getPropertyValue()));
            }
        });
    }

    private static String tableToString(NewSampleComponentWithFixedMaterialType[] table) {
        return LogMessageProvider.tableToString(table, new Converter<NewSampleComponentWithFixedMaterialType>(){

            @Override
            public String toString(NewSampleComponentWithFixedMaterialType o) {
                return String.format("CODE(%s), MATERIAL_CODE(%s)", LogMessageProvider.cite(o.getCode()), LogMessageProvider.cite(o.getMaterialCode()));
            }
        });
    }

    private static String tableToString(NewExperiment[] table) {
        return LogMessageProvider.tableToString(table, new Converter<NewExperiment>(){

            @Override
            public String toString(NewExperiment o) {
                return LogMessageProvider.newExperimentToString(o);
            }
        });
    }

    private static String tableToString(NewSampleComponent[] table) {
        return LogMessageProvider.tableToString(table, new Converter<NewSampleComponent>(){

            @Override
            public String toString(NewSampleComponent o) {
                return String.format("CODE(%s), MATERIAL_CODE(%s) MATERIAL_TYPE(%s)", LogMessageProvider.cite(o.getCode()), LogMessageProvider.cite(o.getMaterialCode()), LogMessageProvider.cite(o.getMaterialTypeCode()));
            }
        });
    }

    private static String tableToString(String[] table) {
        return LogMessageProvider.tableToString(table, new Converter<String>(){

            @Override
            public String toString(String o) {
                return o;
            }
        });
    }

    private static String tableToString(Object[] table, Converter c) {
        if (table == null || table.length == 0) {
            return RESULT_SUCCESS;
        }
        int show = Math.min(3, table.length);
        boolean cutTable = table.length > show;
        String showingStr = String.format(SHOW_N_OUT_OF_M, show, table.length);
        StringBuilder str = new StringBuilder();
        if (cutTable) {
            str.append(showingStr);
        }
        str.append("{");
        int i = 0;
        while (i < show) {
            String temp = String.format("(%s)", c.toString(table[i]));
            str.append(temp);
            if (i + 1 < show) {
                str.append(", ");
            }
            ++i;
        }
        if (cutTable) {
            str.append(AND_SO_ON);
        }
        str.append("}");
        return str.toString();
    }

    private static String cite(String text) {
        return LogMessageProvider.cite(text, true);
    }

    private static String cite(String text, boolean mandatory) {
        if (text == null) {
            if (mandatory) {
                return UNDEFINED;
            }
            return RESULT_SUCCESS;
        }
        return "'" + text + "'";
    }

    public String listSampleTypes() {
        return this.createMessage(LIST_SAMPLE_TYPES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Converter<T> {
        private Converter() {
        }

        public abstract String toString(T var1);
    }
}

