/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.collections.FilteredList;
import ch.systemsx.cisd.common.collections.Validator;
import ch.systemsx.cisd.lims.base.EntityTypeMandatorilyRelation;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.PropertyTypeEntityTypeRelation;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.client.commands.AbstractListEntityPropertyTypesCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPlatePropertyTypesCommand
extends AbstractListEntityPropertyTypesCommand {
    private static final String NAME = "list-plate-property-types";
    private static ListPlatePropertyTypesCommand instance;
    private final Validator<EntityTypeMandatorilyRelation> validator;

    ListPlatePropertyTypesCommand() {
        this(NAME, ListPlatePropertyTypesCommand.getSupportedSampleTypes());
    }

    ListPlatePropertyTypesCommand(String name, SampleTypeCode ... supportedSampleTypes) {
        super(name);
        this.validator = new EntityTypeRelationValidator(supportedSampleTypes);
    }

    private static final SampleTypeCode[] getSupportedSampleTypes() {
        return (SampleTypeCode[])ArrayUtils.removeElement((Object[])SampleTypeCode.values(), (Object)SampleTypeCode.CONTROL_LAYOUT);
    }

    private static final <T> List<T> createModifiableList(T[] objects) {
        return new ArrayList(Arrays.asList(objects));
    }

    public static synchronized ListPlatePropertyTypesCommand getInstance() {
        if (instance == null) {
            instance = new ListPlatePropertyTypesCommand();
        }
        return instance;
    }

    @Override
    final PropertyTypeEntityTypeRelation[] listPropertyTypeRelations(String sessionToken, ILIMSService limsService, EntityKind entityKind) {
        List<PropertyTypeEntityTypeRelation> propertyTypeRelations = ListPlatePropertyTypesCommand.createModifiableList(super.listPropertyTypeRelations(sessionToken, limsService, entityKind));
        for (PropertyTypeEntityTypeRelation propertyTypeEntityTypeRelation : propertyTypeRelations) {
            List<EntityTypeMandatorilyRelation> filteredList = FilteredList.decorate(ListPlatePropertyTypesCommand.createModifiableList(propertyTypeEntityTypeRelation.getRelations()), this.validator);
            propertyTypeEntityTypeRelation.setRelations(filteredList.toArray(EntityTypeMandatorilyRelation.EMPTY_ARRAY));
        }
        return propertyTypeRelations.toArray(PropertyTypeEntityTypeRelation.EMPTY_ARRAY);
    }

    @Override
    String getEntityKindLabel(EntityKind entityKind) {
        return "Plate";
    }

    @Override
    final EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityTypeRelationValidator
    implements Validator<EntityTypeMandatorilyRelation> {
        private final SampleTypeCode[] supportedSampleTypes;

        EntityTypeRelationValidator(SampleTypeCode[] supportedSampleTypes) {
            this.supportedSampleTypes = supportedSampleTypes;
        }

        @Override
        public final boolean isValid(EntityTypeMandatorilyRelation object) {
            String entityTypeCode = object.getEntityType().getCode();
            SampleTypeCode[] sampleTypeCodeArray = this.supportedSampleTypes;
            int n = this.supportedSampleTypes.length;
            int n2 = 0;
            while (n2 < n) {
                SampleTypeCode sampleType = sampleTypeCodeArray[n2];
                if (entityTypeCode.equals(sampleType.getCode())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

