/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Vocabulary;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.VocabularyTableModel;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;

public final class ListVocabulariesCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list-vocabularies";
    private static ListVocabulariesCommand instance;

    private ListVocabulariesCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        OutputTypeParameters parameters = new OutputTypeParameters(arguments, NAME);
        ILIMSService limsService = this.getLIMSService(parameters);
        Vocabulary[] vocabularies = limsService.listVocabularies(sessionToken);
        if (vocabularies.length == 0 && parameters.isPrettyPrinted()) {
            System.out.println("No vocabularies found.");
        } else {
            VocabularyTableModel model = new VocabularyTableModel(vocabularies, parameters.isPrettyPrinted());
            this.printTable(model, parameters);
        }
        return 0;
    }

    public static final synchronized ListVocabulariesCommand getInstance() {
        if (instance == null) {
            instance = new ListVocabulariesCommand();
        }
        return instance;
    }
}

