/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.parameters;

import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.lims.base.MaterialCriteria;
import ch.systemsx.cisd.lims.base.QueryRestriction;
import ch.systemsx.cisd.lims.client.parameters.AbstractTimeIntervalParameter;
import org.kohsuke.args4j.Option;

public class AbstractExperimentFilterParameter
extends AbstractTimeIntervalParameter {
    @Option(name="p", longName="project", metaVar="CODE", usage="Project code")
    private String projectCode;
    @Option(name="o", longName="study-object", metaVar="CODE", usage="Code of studied object")
    private String studyObjectCode;

    public AbstractExperimentFilterParameter(String[] args, String limsCommandName, String genericArgs) {
        super(args, limsCommandName, genericArgs);
    }

    public AbstractExperimentFilterParameter(String[] args, String limsCommandName, String genericArgs, IExitHandler exitHandler) {
        super(args, limsCommandName, genericArgs, exitHandler);
    }

    public final String getProjectCode() {
        return this.projectCode;
    }

    public final String getStudyObjectCode() {
        return this.studyObjectCode;
    }

    public QueryRestriction getQueryRestriction() {
        QueryRestriction queryRestriction = new QueryRestriction();
        queryRestriction.setProjectCode(this.projectCode);
        queryRestriction.setMaterialCriteria(this.tryCreateMaterialCriteria());
        queryRestriction.setTimeInterval(this.getTimeInterval());
        return queryRestriction;
    }

    private final MaterialCriteria tryCreateMaterialCriteria() {
        if (this.studyObjectCode != null) {
            MaterialCriteria materialCriteria = new MaterialCriteria();
            materialCriteria.setCode(this.studyObjectCode);
            return materialCriteria;
        }
        return null;
    }
}

