/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.parameters;

import ch.systemsx.cisd.lims.base.LimitFilter;
import ch.systemsx.cisd.lims.base.SampleFilter;
import ch.systemsx.cisd.lims.client.parameters.AbstractBufferParameters;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.args4j.Option;

public abstract class PatternAndLimitParameters
extends AbstractBufferParameters {
    @Option(name="l", longName="limit", metaVar="number", usage="Maximum number of results returned (per default -1, meaning that no limit is set)")
    private Integer limit;
    private final int patternsStart;

    public PatternAndLimitParameters(String[] args, String limsCommand, String genericArgs, int patternsStart) {
        super(args, limsCommand, genericArgs);
        this.patternsStart = patternsStart;
    }

    public SampleFilter getSampleFilter() {
        return new SampleFilter(this.getPatterns(), false, true);
    }

    public final String[] getPatterns() {
        List<String> args = this.getArgs();
        int size = args.size();
        if (size > this.patternsStart) {
            return args.subList(this.patternsStart, size).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public final LimitFilter getLimitFilter() {
        if (this.limit == null) {
            this.limit = -1;
        }
        LimitFilter limitFilter = new LimitFilter();
        limitFilter.setLimit(this.limit);
        return limitFilter;
    }
}

