/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.collections.FilteredList;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.EntityType;
import ch.systemsx.cisd.lims.base.LimitFilter;
import ch.systemsx.cisd.lims.base.Material;
import ch.systemsx.cisd.lims.base.PlainMaterial;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IMaterialManager;
import ch.systemsx.cisd.lims.server.business.MaterialValidator;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IMaterialTable;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MaterialManager
extends AbstractManager
implements IMaterialManager {
    MaterialManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    private PlainMaterial[] convert(List<MaterialDTO> materials) {
        BeanUtils.Converter converter = this.createMaterialPropertiesConverter();
        return BeanUtils.createBeanArray(PlainMaterial.class, materials, converter);
    }

    private static final void checkNonExistingInhibitor(List<String> moleculesWithNonExistingInhibitorOf, StringBuilder builder) {
        if (moleculesWithNonExistingInhibitorOf.size() > 0) {
            if (builder.length() > 0) {
                builder.append(" and t");
            } else {
                builder.append('\n');
                builder.append("  ");
                builder.append("T");
            }
            builder.append("he inhibitor-of relation of following items '").append(CollectionUtils.abbreviate(moleculesWithNonExistingInhibitorOf, 10)).append("' is invalid (specified inhibitor does not exist or has a wrong type)");
        }
    }

    private final long getMaterialTypeId(String materialTypeCode) {
        IEntityTypeDAO entityTypeDAO = this.daoFactory.getEntityTypeDAO(EntityKind.MATERIAL);
        EntityTypeDTO materialType = entityTypeDAO.tryToFindEntityTypeByCode(materialTypeCode);
        if (materialType == null) {
            throw UserFailureException.fromTemplate("Material type with the code '%s' does not exist!", materialTypeCode);
        }
        return materialType.getId();
    }

    @Override
    @Transactional
    public final EntityType[] listMaterialTypes() throws UserFailureException {
        IEntityTypeDAO entityTypeDAO = this.daoFactory.getEntityTypeDAO(EntityKind.MATERIAL);
        List<EntityType> list = BeanUtils.createBeanList(EntityType.class, entityTypeDAO.listEntityTypes());
        return list.toArray(new EntityType[list.size()]);
    }

    @Override
    @Transactional
    public final PlainMaterial[] listMaterials(Session session, String materialTypeCode, String[] codePatterns, LimitFilter limitFilter) throws UserFailureException {
        ParameterChecker.checkIfNotNull(materialTypeCode, "material type code");
        ParameterChecker.checkIfNotNull(codePatterns, "code patterns");
        this.getMaterialTypeId(materialTypeCode);
        IMaterialTable materialTable = this.boFactory.createMaterialTable(session);
        materialTable.loadByMaterialType(materialTypeCode);
        materialTable.enrichWithRegistrator();
        List<MaterialDTO> materials = materialTable.getMaterials();
        if (codePatterns.length > 0) {
            materials = FilteredList.decorate(materials, new MaterialValidator(codePatterns));
        }
        if (limitFilter != null) {
            materials = MaterialManager.subList(limitFilter, materials);
        }
        return this.convert(materials);
    }

    @Override
    @Transactional
    public final void registerMaterials(Session session, Material[] materials, String materialTypeCode) throws UserFailureException {
        ParameterChecker.checkIfNotNull(materials, "materials");
        ParameterChecker.checkIfNotNull(materialTypeCode, "material type code");
        StringBuilder builder = new StringBuilder();
        IMaterialTable materialTable = this.boFactory.createMaterialTable(session);
        Material[] materialArray = materials;
        int n = materials.length;
        int n2 = 0;
        while (n2 < n) {
            Material material = materialArray[n2];
            materialTable.add(material);
            ++n2;
        }
        materialTable.save();
        List<String> alreadyRegisteredMaterials = materialTable.getAlreadyRegisteredMaterials();
        if (alreadyRegisteredMaterials.size() > 0) {
            builder.append('\n');
            builder.append("  Following items of type '").append(materialTypeCode).append("' are already registered ");
            builder.append(CollectionUtils.abbreviate(alreadyRegisteredMaterials, 10));
        }
        MaterialManager.checkNonExistingInhibitor(materialTable.getMaterialsWithNonExistingInhibitorOf(), builder);
        if (builder.length() > 0) {
            throw new UserFailureException("Registration failed because of following reason:" + builder);
        }
    }
}

