/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.Vocabulary;
import ch.systemsx.cisd.lims.base.VocabularyTerm;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IPropertyTypeManager;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IPersonBO;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyTypeTable;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.lims.server.dto.VocabularyDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyTermDTO;
import java.util.HashSet;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyTypeManager
extends AbstractManager
implements IPropertyTypeManager {
    PropertyTypeManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    @Override
    @Transactional
    public final void registerPropertyTypes(Session session, PropertyType[] properties) throws UserFailureException {
        assert (session != null) : "Session can not be null.";
        ParameterChecker.checkPropertyType(properties);
        IPropertyTypeTable propertyTypeTable = this.boFactory.createPropertyTypeTable(session);
        propertyTypeTable.load();
        PropertyType[] propertyTypeArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyType propertyType = propertyTypeArray[n2];
            propertyTypeTable.add(propertyType);
            ++n2;
        }
        propertyTypeTable.save();
        List<String> duplicatePropertyTypes = propertyTypeTable.getDuplicatePropertyTypes();
        StringBuilder builder = new StringBuilder();
        if (duplicatePropertyTypes.size() > 0) {
            builder.append("Following items are already registered '").append(CollectionUtils.abbreviate(duplicatePropertyTypes, 10)).append("'.");
        }
        if (builder.length() > 0) {
            throw new UserFailureException(builder.toString());
        }
    }

    @Override
    @Transactional
    public long countEntitiesWithProperty(Session session, EntityKind entityKind, String entityTypeCode, String propertyTypeCode) {
        assert (session != null) : "Session can not be null.";
        ParameterChecker.checkIfNotNull((Object)entityKind, "entity kind");
        ParameterChecker.checkIfNotNull(entityTypeCode, String.valueOf(entityKind.getLabel()) + " type code");
        ParameterChecker.checkIfNotNull(propertyTypeCode, "property type code");
        IPropertyTypeDAO propertyTypeDAO = this.daoFactory.getPropertyTypeDAO();
        Long propertyTypeId = propertyTypeDAO.tryFindPropertyTypeIdByCode(propertyTypeCode);
        if (propertyTypeId == null) {
            throw UserFailureException.fromTemplate("Property type with the name '%s' does not exist!", propertyTypeCode);
        }
        try {
            IEntityTypeDAO entityTypeDAO = this.daoFactory.getEntityTypeDAO(entityKind);
            long entityTypeID = entityTypeDAO.getEntityTypeIDByCode(entityTypeCode);
            IEntityPropertyTypeDAO entityPropertyTypeDAO = this.daoFactory.getEntityPropertyTypeDAO(entityKind);
            return entityPropertyTypeDAO.countEntitiesWithProperty(entityTypeID, propertyTypeId);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            throw UserFailureException.fromTemplate("No %s type could be found for code '%s'.", entityKind.getLabel(), entityTypeCode);
        }
    }

    @Override
    @Transactional
    public void registerVocabulary(Session session, String vocabularyName, String vocabularyDescOrNull, String[] vocabularyTerms, boolean addTerms) {
        VocabularyDTO vocabularyDTO;
        ParameterChecker.checkIfNotNull(vocabularyName, "vocabulary name");
        ParameterChecker.checkIfNotNull(vocabularyTerms, "vocabulary terms");
        this.checkTerms(vocabularyName, vocabularyTerms, addTerms);
        Long registratorId = this.getRegistratorId(session);
        IVocabularyDAO vocabularyDAO = this.daoFactory.getVocabularyDAO();
        if (!addTerms) {
            vocabularyDTO = new VocabularyDTO(vocabularyName, vocabularyDescOrNull, registratorId);
            try {
                vocabularyDAO.create(vocabularyDTO);
            }
            catch (DataAccessException ex) {
                DataAccessExceptionTranslator.throwException(ex, "Controlled Vocabulary set " + vocabularyName);
            }
        } else {
            vocabularyDTO = vocabularyDAO.tryFindByCode(vocabularyName);
            if (vocabularyDTO == null) {
                throw UserFailureException.fromTemplate("Vocabulary '" + vocabularyName + "' does not exist, so terms cannot be added.", new Object[0]);
            }
            if (vocabularyDTO.isManagedInternally()) {
                throw UserFailureException.fromTemplate("Vocabulary '" + vocabularyName + "' is managed internally, so terms cannot be added.", new Object[0]);
            }
        }
        Long vocabularyId = vocabularyDTO.getId();
        String[] stringArray = vocabularyTerms;
        int n = vocabularyTerms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            this.createVocabularyTerm(term, registratorId, vocabularyId, vocabularyDAO, vocabularyName);
            ++n2;
        }
    }

    private void createVocabularyTerm(String term, Long registratorId, Long vocabularyId, IVocabularyDAO vocabularyDAO, String vocabularyCode) {
        try {
            vocabularyDAO.createTerm(new VocabularyTermDTO(term, vocabularyId, registratorId));
        }
        catch (DataAccessException dataAccessException) {
            throw new UserFailureException(String.format("Vocabulary term '%s' already exists in vocabulary '%s'", term, vocabularyCode));
        }
    }

    private Long getRegistratorId(Session session) {
        IPersonBO personBO = this.boFactory.createPersonBO(session);
        return personBO.getLoggedInUserId();
    }

    private void checkTerms(String vocabularyName, String[] vocabularyTerms, boolean addTerms) {
        if (vocabularyTerms.length == 0) {
            throw UserFailureException.fromTemplate(addTerms ? "There are no new terms which could be added to vocabulary '%s'." : "There are no terms in the vocabulary '%s', so it can not be created.", vocabularyName);
        }
        HashSet<String> termsSet = new HashSet<String>();
        String[] stringArray = vocabularyTerms;
        int n = vocabularyTerms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            if (term.length() == 0) {
                throw UserFailureException.fromTemplate("One of the vocabulary terms is empty, so the vocabulary '%s' %s.", vocabularyName, addTerms ? "couldn't be changed" : "can not be created");
            }
            String termCanonic = term.toLowerCase();
            if (termsSet.contains(termCanonic)) {
                throw UserFailureException.fromTemplate("Duplicated term '%s' for the vocabulary '%s'. Remember, that terms are case insensitive.", term, vocabularyName);
            }
            termsSet.add(termCanonic);
            ++n2;
        }
    }

    @Override
    @Transactional
    public List<Vocabulary> listVocabularies(Session session) {
        assert (session != null) : "Session can not be null.";
        List<Vocabulary> vocabularyList = BeanUtils.createBeanList(Vocabulary.class, this.daoFactory.getVocabularyDAO().listVocabularies());
        return vocabularyList;
    }

    @Override
    @Transactional
    public List<VocabularyTerm> listVocabularyTerms(Session session, String vocabularyCode) {
        assert (session != null) : "Session can not be null.";
        assert (vocabularyCode != null) : "Vocabulary code can not be null.";
        List<VocabularyTerm> vocabularyTermList = BeanUtils.createBeanList(VocabularyTerm.class, this.daoFactory.getVocabularyDAO().listVocabularyTerms(vocabularyCode));
        if (vocabularyTermList.size() == 0) {
            throw UserFailureException.fromTemplate("Vocabulary with code '%s' does not exist.", vocabularyCode);
        }
        return vocabularyTermList;
    }
}

