/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentAttachmentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IFileFormatTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IGroupDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IInvalidationDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ILocatorTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialBatchDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IObservableTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleComponentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IVocabularyDAO;
import org.springframework.dao.DataAccessException;

abstract class AbstractBusinessObject
implements IDAOFactory {
    private final IDAOFactory daoFactory;
    protected final Session session;
    private Long registratorID;

    AbstractBusinessObject(IDAOFactory daoFactory, Session session) {
        assert (daoFactory != null) : "Given DAO factory can not be null.";
        assert (session != null) : "Given session can not be null.";
        this.daoFactory = daoFactory;
        this.session = session;
    }

    protected final Long findRegistratorID() {
        if (this.registratorID == null) {
            String user = this.session.getUserName();
            this.registratorID = this.daoFactory.getPersonDAO().tryFindPersonIdByUserID(user);
            if (this.registratorID == null) {
                throw new UserFailureException("Invalid user ID: " + user);
            }
        }
        return this.registratorID;
    }

    protected static final void throwException(DataAccessException exception, String subject) throws UserFailureException {
        DataAccessExceptionTranslator.throwException(exception, subject);
    }

    public final IExperimentDAO getExperimentDAO() {
        return this.daoFactory.getExperimentDAO();
    }

    public final IExperimentAttachmentDAO getExperimentAttachmentDAO() {
        return this.daoFactory.getExperimentAttachmentDAO();
    }

    public final IExperimentTypeDAO getExperimentTypeDAO() {
        return this.daoFactory.getExperimentTypeDAO();
    }

    public final IExternalDataDAO getExternalDataDAO() {
        return this.daoFactory.getExternalDataDAO();
    }

    public final IFileFormatTypeDAO getFileFormatTypeDAO() {
        return this.daoFactory.getFileFormatTypeDAO();
    }

    public final ILocatorTypeDAO getLocatorTypeDAO() {
        return this.daoFactory.getLocatorTypeDAO();
    }

    public final IMaterialBatchDAO getMaterialBatchDAO() {
        return this.daoFactory.getMaterialBatchDAO();
    }

    public final IMaterialDAO getMaterialDAO() {
        return this.daoFactory.getMaterialDAO();
    }

    public final IObservableTypeDAO getObservableTypeDAO() {
        return this.daoFactory.getObservableTypeDAO();
    }

    public final IGroupDAO getGroupDAO() {
        return this.daoFactory.getGroupDAO();
    }

    public final IPersonDAO getPersonDAO() {
        return this.daoFactory.getPersonDAO();
    }

    public final IProcedureDAO getProcedureDAO() {
        return this.daoFactory.getProcedureDAO();
    }

    public final IProcedureTypeDAO getProcedureTypeDAO() {
        return this.daoFactory.getProcedureTypeDAO();
    }

    public final IProjectDAO getProjectDAO() {
        return this.daoFactory.getProjectDAO();
    }

    public final ISampleComponentDAO getSampleComponentDAO() {
        return this.daoFactory.getSampleComponentDAO();
    }

    public final ISampleDAO getSampleDAO() {
        return this.daoFactory.getSampleDAO();
    }

    public final ISampleTypeDAO getSampleTypeDAO() {
        return this.daoFactory.getSampleTypeDAO();
    }

    public final IEntityPropertyTypeDAO getEntityPropertyTypeDAO(EntityKind entityKind) {
        return this.daoFactory.getEntityPropertyTypeDAO(entityKind);
    }

    public final IPropertyTypeDAO getPropertyTypeDAO() {
        return this.daoFactory.getPropertyTypeDAO();
    }

    public final IInvalidationDAO getInvalidationDAO() {
        return this.daoFactory.getInvalidationDAO();
    }

    public final IVocabularyDAO getVocabularyDAO() {
        return this.daoFactory.getVocabularyDAO();
    }

    public IEntityTypeDAO getEntityTypeDAO(EntityKind entityKind) {
        return this.daoFactory.getEntityTypeDAO(entityKind);
    }
}

