/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.db.SQLStateUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public final class DataAccessExceptionTranslator {
    static final String UNIQUE_VIOLATION_FORMAT = "%s already exists in the database and needs to be unique.";

    private DataAccessExceptionTranslator() {
    }

    public static final void throwException(DataAccessException exception, String subject) throws UserFailureException {
        assert (StringUtils.isNotBlank(subject)) : "Given subject can not be blank.";
        DataAccessExceptionTranslator.throwExceptionWithMsg(exception, String.format(UNIQUE_VIOLATION_FORMAT, StringUtils.capitalize(subject)));
    }

    public static final void throwExceptionWithMsg(DataAccessException exception, String uniqueViolationMsg) throws UserFailureException {
        String sqlState;
        assert (exception != null) : "DataAccessException not specified.";
        if (exception instanceof DataIntegrityViolationException && SQLStateUtils.isUniqueViolation(sqlState = SQLStateUtils.getSqlState(exception))) {
            throw new UserFailureException(uniqueViolationMsg, exception);
        }
        throw new UserFailureException(exception.getMessage(), exception);
    }
}

