/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IPersonBO;
import ch.systemsx.cisd.lims.server.business.bo.PrincipalAdapter;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import org.springframework.dao.DataAccessException;

final class PersonBO
extends AbstractBusinessObject
implements IPersonBO {
    private PersonDTO personDTO;
    private boolean shouldBeSaved;

    PersonBO(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    private final String getUserId() {
        String user = this.session.getUserName();
        assert (user != null) : "User id can not be null";
        return user;
    }

    public final void define() {
        String user = this.getUserId();
        Principal principal = this.session.getPrincipal();
        this.personDTO = principal != null ? new PrincipalAdapter(principal) : new PersonDTO();
        this.personDTO.setUserId(user);
        this.shouldBeSaved = true;
    }

    public final PersonDTO getPerson() {
        return this.personDTO;
    }

    public final void load() {
        String user = this.getUserId();
        Long id = this.getPersonDAO().tryFindPersonIdByUserID(user);
        if (id != null) {
            this.personDTO = this.getPersonDAO().getPerson(id);
        }
        this.shouldBeSaved = false;
    }

    public final void save() {
        if (this.shouldBeSaved) {
            assert (this.personDTO != null) : "Can not save an undefined person.";
            try {
                this.getPersonDAO().createPerson(this.personDTO);
                this.shouldBeSaved = false;
            }
            catch (DataAccessException ex) {
                PersonBO.throwException(ex, String.format("User id '%s'", this.personDTO.getUserId()));
            }
        }
    }

    public Long getLoggedInUserId() {
        if (this.personDTO != null) {
            return this.personDTO.getId();
        }
        return super.findRegistratorID();
    }
}

