/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.PropertyType;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractEntityDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.lims.server.dto.EntityIntegrityDTO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyTypeAssignmentDTO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.ICodeAndIDHolder;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EntityPropertyTypeDAO
extends AbstractEntityDAO
implements IEntityPropertyTypeDAO {
    private static final String SELECT_FROM = "select etpt.id, etpt.is_mandatory, etpt.is_managed_internally, ${fk_entity_type} as entity_type_id, etpt.prty_id, etpt.pers_id_registerer from ${entity_property_type} as etpt ";
    private static final String SELECT_FROM_WHERE_USER_PROPERTY_TYPE = "select etpt.id, etpt.is_mandatory, etpt.is_managed_internally, ${fk_entity_type} as entity_type_id, etpt.prty_id, etpt.pers_id_registerer from ${entity_property_type} as etpt , property_types as prty where etpt.prty_id = prty.id and prty.is_internal_namespace = false ";
    private static final Logger operationExTrackingLog = LogFactory.getLogger(LogCategory.OPERATION, EntityPropertyTypeDAO.class);
    private static final ParameterizedRowMapper<EntityIntegrityDTO> INTEGRITY_ROW_MAPPER = new ParameterizedRowMapper<EntityIntegrityDTO>(){

        public EntityIntegrityDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            EntityIntegrityDTO dto = new EntityIntegrityDTO();
            dto.setPropertyID(rs.getLong("id"));
            dto.setPropertyName(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            dto.setEntityTypeViaEntityTable(rs.getString("et_via_e"));
            dto.setEntityTypeViaETPTTable(rs.getString("et_via_etpt"));
            return dto;
        }
    };
    private static final ParameterizedRowMapper<EntityPropertySchema> ENTITY_PROPERTY_SCHEMA_ROW_MAPPER = new ParameterizedRowMapper<EntityPropertySchema>(){

        public EntityPropertySchema mapRow(ResultSet rs, int rowNum) throws SQLException {
            PropertyType propertyType = this.mapPropertyType(rs);
            boolean mandatory = rs.getBoolean("is_mandatory");
            long id = rs.getLong("etpt_id");
            Date registrationDate = new Date(rs.getTimestamp("registration_timestamp").getTime());
            PersonDTO personDTO = PersonDAO.fillPersonFromResultSet(rs);
            Person registrator = BeanUtils.createBean(Person.class, personDTO);
            return new EntityPropertySchema(id, mandatory, registrationDate, registrator, propertyType);
        }

        private PropertyType mapPropertyType(ResultSet rs) throws SQLException {
            boolean internalNamespace = rs.getBoolean("prty_is_internal_namespace");
            String code = CodeConverter.tryToBusinessLayer(rs.getString("prty_code"), !internalNamespace);
            String dataTypeCode = CodeConverter.tryToBusinessLayer(rs.getString("daty_code"));
            String label = rs.getString("prty_label");
            String description = rs.getString("prty_description");
            boolean vocabularyCodeIsInternalNamespace = rs.getBoolean("covo_is_internal_namespace");
            String vocabularyCode = CodeConverter.tryToBusinessLayer(rs.getString("covo_code"), !vocabularyCodeIsInternalNamespace);
            PropertyType propertyType = new PropertyType(code, dataTypeCode, label, description, vocabularyCode);
            Date date = new Date(rs.getTimestamp("prty_registration_timestamp").getTime());
            propertyType.setInternalNamespace(internalNamespace);
            propertyType.setRegistrationDate(date);
            propertyType.setRegistrator(null);
            return propertyType;
        }
    };
    private static final ParameterizedRowMapper<EntityPropertyTypeAssignmentDTO> RELATION_ROW_MAPPER = new ParameterizedRowMapper<EntityPropertyTypeAssignmentDTO>(){

        public EntityPropertyTypeAssignmentDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            long entityTypeID = rs.getLong("entity_type_id");
            long propertyTypeID = rs.getLong("prty_id");
            Long registererId = rs.getLong("pers_id_registerer");
            EntityPropertyTypeAssignmentDTO result = new EntityPropertyTypeAssignmentDTO(registererId, entityTypeID, propertyTypeID);
            result.setId(rs.getLong("id"));
            result.setMandatory(rs.getBoolean("is_mandatory"));
            result.setManagedInternally(rs.getBoolean("is_managed_internally"));
            return result;
        }
    };
    private static final ParameterizedRowMapper<ICodeAndIDHolder> ENTITY_CODE_MAPPER = new ParameterizedRowMapper<ICodeAndIDHolder>(){

        public ICodeAndIDHolder mapRow(ResultSet rs, int rowNum) throws SQLException {
            final String code = CodeConverter.tryToBusinessLayer(rs.getString("code"));
            final Long id = rs.getLong("id");
            return new ICodeAndIDHolder(){

                public Long getId() {
                    return id;
                }

                public String getCode() {
                    return code;
                }
            };
        }
    };
    private final ISequenceNameMapper sequenceNameMapper;

    public EntityPropertyTypeDAO(EntityKind entityKind, DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(entityKind, dataSource, dtoValidatorStore, sequencerHandler);
        this.sequenceNameMapper = sequenceNameMapper;
    }

    private final long nextEntityPropertyTypeId() {
        return this.createId(this.entityPropertyTableNames.getEntityPropertyTypeTableName());
    }

    private final long nextEntityPropertyId() {
        return this.createId(this.entityPropertyTableNames.getEntityPropertyTableName());
    }

    private final long createId(String tableName) {
        String sequencer = this.sequenceNameMapper.getSequencerForTable(tableName);
        return this.getNextValueOf(sequencer);
    }

    private IncorrectResultSizeDataAccessException internalErrorManyAssignments(long entityTypeId, long propertyTypeId, int size) {
        String errorMsg = String.format("More than one property type assignment found entity for property type id '%s' and entity type id '%s'", propertyTypeId, entityTypeId);
        return new IncorrectResultSizeDataAccessException(errorMsg, 1, size);
    }

    private final void createProperties(EntityPropertyValueDTO[] properties, long entityId) {
        EntityPropertyValueDTO[] entityPropertyValueDTOArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            EntityPropertyValueDTO property = entityPropertyValueDTOArray[n2];
            this.createPropertyValue(entityId, property);
            ++n2;
        }
    }

    @Override
    public List<EntityIntegrityDTO> listIntegrityViolations() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql("select ep.id, pt.code, et1.code as et_via_e, et2.code as et_via_etpt from ${entity_property} as ep, ${entity} as e, ${entity_type} as et1,      ${entity_property_type} as etpt, ${entity_type} as et2, property_types as pt where ep.${fk_entity} = e.id and e.${fk_entity_type} = et1.id   and ep.${fk_entity_property_type} = etpt.id and etpt.${fk_entity_type} = et2.id   and etpt.prty_id = pt.id and not e.${fk_entity_type} = etpt.${fk_entity_type}");
        return template.query(sql, INTEGRITY_ROW_MAPPER, new Object[0]);
    }

    @Override
    public final List<EntityPropertySchema> listEntityPropertyTypes(long entityTypeId) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql("select ps.id as pid, ps.user_id as user_id, ps.first_name as first_name, ps.last_name as last_name, ps.email as email, etpt.pers_id_registerer as pers_id_registerer, etpt.registration_timestamp as registration_timestamp, etpt.is_mandatory as is_mandatory, etpt.id as etpt_id, prty.code as prty_code, prty.is_internal_namespace as prty_is_internal_namespace, prty.description as prty_description, prty.label as prty_label, prty.registration_timestamp as prty_registration_timestamp, daty.code as daty_code, daty.description as daty_description, covo.is_internal_namespace as covo_is_internal_namespace, covo.code as covo_code from property_types prty left outer join controlled_vocabularies covo on prty.covo_id = covo.id, persons ps, ${entity_type} etype, ${entity_property_type} etpt, data_types daty where daty.id = prty.daty_id and etpt.prty_id = prty.id and ps.id=etpt.pers_id_registerer and etpt.${fk_entity_type} = etype.id and etype.id = ? order by prty_code ");
        return template.query(sql, ENTITY_PROPERTY_SCHEMA_ROW_MAPPER, new Object[]{entityTypeId});
    }

    @Override
    public final void createEntityPropertyTypeAssignment(EntityPropertyTypeAssignmentDTO entityPropertyType) {
        assert (entityPropertyType != null) : "Missing entity property type assignment.";
        Long entityTypeID = entityPropertyType.getEntityTypeID();
        assert (entityTypeID != null) : "Missing entity type id.";
        Long propertyTypeID = entityPropertyType.getPropertyTypeID();
        assert (propertyTypeID != null) : "Missing property type id.";
        Long registratorID = entityPropertyType.getRegistratorID();
        assert (registratorID != null) : "Missing registrator ID.";
        long id = this.nextEntityPropertyTypeId();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql("insert into ${entity_property_type}  (id, ${fk_entity_type}, prty_id, is_mandatory, pers_id_registerer) values (?,?,?,?,?)");
        template.update(sql, new Object[]{id, entityTypeID, propertyTypeID, entityPropertyType.isMandatory(), entityPropertyType.getRegistratorID()});
        if (operationExTrackingLog.isInfoEnabled()) {
            operationExTrackingLog.info("ADD: assignment of property " + propertyTypeID + " with entity type " + entityTypeID);
        }
        entityPropertyType.setId(id);
    }

    @Override
    public EntityPropertyTypeAssignmentDTO tryFindAssignment(long entityTypeId, long propertyTypeId) {
        String sql = this.createPropertiesSql(this.createPropertiesSql("select etpt.id, etpt.is_mandatory, etpt.is_managed_internally, ${fk_entity_type} as entity_type_id, etpt.prty_id, etpt.pers_id_registerer from ${entity_property_type} as etpt where ${fk_entity_type} = ? and prty_id = ?"));
        List assignment = this.getSimpleJdbcTemplate().query(sql, RELATION_ROW_MAPPER, new Object[]{entityTypeId, propertyTypeId});
        int size = assignment.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (EntityPropertyTypeAssignmentDTO)assignment.get(0);
        }
        throw this.internalErrorManyAssignments(entityTypeId, propertyTypeId, size);
    }

    @Override
    public final void unassignEntityPropertyType(long entityTypeId, long propertyTypeId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql("delete from ${entity_property_type} where ${fk_entity_type} = ? and prty_id = ?");
        int affected = template.update(sql, new Object[]{entityTypeId, propertyTypeId});
        if (operationExTrackingLog.isInfoEnabled()) {
            operationExTrackingLog.info("REMOVE: " + affected + " rows affected by removing of [propertyTypeId=" + propertyTypeId + ",entityTypeId=" + entityTypeId + "].");
        }
    }

    @Override
    public final void updateMandatoryFlag(long entityPropertyTypeId, boolean isMandatory) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql("update ${entity_property_type} set is_mandatory = ? where id = ?");
        template.update(sql, new Object[]{isMandatory, entityPropertyTypeId});
        if (operationExTrackingLog.isInfoEnabled()) {
            operationExTrackingLog.info("UPDATE: Property " + entityPropertyTypeId + " is updated to be " + (isMandatory ? "mandatory" : "optional"));
        }
    }

    @Override
    public final List<ICodeAndIDHolder> listEntitiesWithMissingPropertyValues(long entityTypeId, long entityPropertyTypeId) {
        String sql = this.createPropertiesSql("select entity.id, entity.code from ${entity} as entity where entity.${fk_entity_type} = ? and    (select count(*) from ${entity_property} as entity_prop      where entity.id = entity_prop.${fk_entity}         and entity_prop.${fk_entity_property_type} = ?) = 0");
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return template.query(sql, ENTITY_CODE_MAPPER, new Object[]{entityTypeId, entityPropertyTypeId});
    }

    @Override
    public final List<EntityPropertyTypeAssignmentDTO> listEntityPropertyTypeRelations() {
        String sql = this.createPropertiesSql(SELECT_FROM_WHERE_USER_PROPERTY_TYPE);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return template.query(sql, RELATION_ROW_MAPPER, new Object[0]);
    }

    @Override
    public final void createProperties(IEntityPropertiesHolderDTO propertiesHolder) {
        this.createProperties(propertiesHolder.getProperties(), propertiesHolder.getEntityId());
    }

    @Override
    public final void createPropertyValue(long entityId, EntityPropertyValueDTO propertyValue) {
        String value = propertyValue.tryGetUntypedValue();
        if (value != null) {
            long id = this.nextEntityPropertyId();
            Long vocabularyTermId = propertyValue.getVocabularyTermId();
            if (vocabularyTermId != null) {
                value = null;
            }
            String sql = this.createPropertiesSql("insert into ${entity_property} (id, ${fk_entity}, ${fk_entity_property_type}, value, pers_id_registerer, cvte_id) values (?,?,?,?,?,?)");
            SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
            template.update(sql, new Object[]{id, entityId, propertyValue.getEntityPropertyTypeId(), value, propertyValue.getRegistratorID(), vocabularyTermId});
        }
    }

    @Override
    public final long countEntitiesWithProperty(long entityTypeId, long propertyTypeId) throws DataAccessException {
        String sql = this.createPropertiesSql("select count(*) from ${entity_property} as ep, ${entity_property_type} as etpt where ep.${fk_entity_property_type} = etpt.id and etpt.${fk_entity_type} = ? and etpt.prty_id = ?");
        return this.getSimpleJdbcTemplate().queryForLong(sql, new Object[]{entityTypeId, propertyTypeId});
    }
}

