/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyTableNames;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityTypeDAO
extends AbstractDAO
implements IEntityTypeDAO {
    private static final EntityTypeRowMapper ENTITY_TYPE_ROW_MAPPER = new EntityTypeRowMapper();
    private final String tableName;

    EntityTypeDAO(EntityKind entityKind, DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.tableName = EntityPropertyTableNames.resolve(entityKind).getEntityTypeTableName();
    }

    @Override
    public long getEntityTypeIDByCode(String code) throws DataAccessException {
        assert (code != null) : "Unspecified entity type code.";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return template.queryForLong("select id from " + this.tableName + " where code = ?", new Object[]{CodeConverter.tryToDatabase(code)});
    }

    @Override
    public List<EntityTypeDTO> listEntityTypes() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from " + this.tableName, (ParameterizedRowMapper)ENTITY_TYPE_ROW_MAPPER, new Object[0]);
        return list;
    }

    @Override
    public EntityTypeDTO tryToFindEntityTypeByCode(String code) throws DataAccessException {
        assert (code != null) : "Unspecified entity type code.";
        String mangledCode = CodeConverter.tryToDatabase(code);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from " + this.tableName + " where code = ?", (ParameterizedRowMapper)ENTITY_TYPE_ROW_MAPPER, new Object[]{mangledCode});
        int size = list.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return (EntityTypeDTO)list.get(0);
            }
        }
        throw new IncorrectResultSizeDataAccessException("More than one entity for code '" + mangledCode + "' found: " + size, 1, size);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityTypeRowMapper
    implements ParameterizedRowMapper<EntityTypeDTO> {
        private EntityTypeRowMapper() {
        }

        public final EntityTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            EntityTypeDTO result = new EntityTypeDTO();
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setDescription(rs.getString("description"));
            return result;
        }
    }
}

